/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.util.Optional;
import ratpack.func.Block;
import ratpack.func.Function;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.server.RatpackServer;

public abstract class ServerCapturer {
    private static final ThreadLocal<Overrides> OVERRIDES_HOLDER = ThreadLocal.withInitial(Overrides::new);
    private static final ThreadLocal<RatpackServer> SERVER_HOLDER = new ThreadLocal();

    private ServerCapturer() {
    }

    public static Optional<RatpackServer> capture(Block bootstrap) throws Exception {
        return ServerCapturer.capture(new Overrides(), bootstrap);
    }

    public static Optional<RatpackServer> capture(Overrides overrides, Block bootstrap) throws Exception {
        OVERRIDES_HOLDER.set(overrides);
        try {
            bootstrap.execute();
        }
        finally {
            OVERRIDES_HOLDER.remove();
        }
        RatpackServer ratpackServer = SERVER_HOLDER.get();
        SERVER_HOLDER.remove();
        return Optional.ofNullable(ratpackServer);
    }

    public static Overrides capture(RatpackServer server) throws Exception {
        SERVER_HOLDER.set(server);
        return OVERRIDES_HOLDER.get();
    }

    public static class Overrides {
        private int port = -1;
        private Function<? super Registry, ? extends Registry> registryFunction = Function.constant(Registries.empty());
        private Boolean development;

        public Overrides port(int port) {
            this.port = port;
            return this;
        }

        public Overrides registry(Function<? super Registry, ? extends Registry> registryFunction) {
            this.registryFunction = registryFunction;
            return this;
        }

        public Overrides development(boolean development) {
            this.development = development;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Function<? super Registry, ? extends Registry> getRegistryFunction() {
            return this.registryFunction;
        }

        public Boolean isDevelopment() {
            return this.development;
        }
    }
}

