/*
 * Decompiled with CFR 0.152.
 */
package ratpack.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class SSLContexts {
    public static SSLContext sslContext(URL keyStoreFile, String password) throws GeneralSecurityException, IOException {
        try (InputStream stream = keyStoreFile.openStream();){
            SSLContext sSLContext = SSLContexts.sslContext(stream, password);
            return sSLContext;
        }
    }

    public static SSLContext sslContext(File keyStoreFile, String password) throws GeneralSecurityException, IOException {
        try (FileInputStream stream = new FileInputStream(keyStoreFile);){
            SSLContext sSLContext = SSLContexts.sslContext((InputStream)stream, password);
            return sSLContext;
        }
    }

    public static SSLContext sslContext(Path keyStoreFile, String password) throws GeneralSecurityException, IOException {
        try (InputStream stream = Files.newInputStream(keyStoreFile, new OpenOption[0]);){
            SSLContext sSLContext = SSLContexts.sslContext(stream, password);
            return sSLContext;
        }
    }

    public static SSLContext sslContext(InputStream keyStoreStream, String password) throws GeneralSecurityException, IOException {
        return SSLContexts.sslContext(keyStoreStream, password.toCharArray());
    }

    private static SSLContext sslContext(InputStream keyStoreStream, char[] password) throws GeneralSecurityException, IOException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(keyStoreStream, password);
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(keyStore, password);
        sslContext.init(factory.getKeyManagers(), null, null);
        return sslContext;
    }

    private SSLContexts() {
    }
}

