/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CompletableFuture;
import ratpack.exec.Result;

public interface Fulfiller<T> {
    public void error(Throwable var1);

    public void success(T var1);

    default public void accept(Result<? extends T> result) {
        if (result.isSuccess()) {
            this.success(result.getValue());
        } else {
            this.error(result.getThrowable());
        }
    }

    default public void accept(CompletableFuture<? extends T> future) {
        future.handle((value, failure) -> {
            if (failure == null) {
                this.success(value);
            } else {
                this.error((Throwable)failure);
            }
            return null;
        });
    }

    default public void accept(ListenableFuture<? extends T> listenableFuture) {
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                Fulfiller.this.success(result);
            }

            public void onFailure(Throwable t) {
                Fulfiller.this.error(t);
            }
        });
    }
}

