/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import javax.net.ssl.SSLContext;
import ratpack.func.Action;
import ratpack.http.MutableHeaders;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.RequestParams;
import ratpack.http.internal.HttpHeaderConstants;

class RequestSpecBacking {
    private final MutableHeaders headers;
    private final URI uri;
    private final ByteBufAllocator byteBufAllocator;
    private final RequestParams requestParams;
    private boolean decompressResponse;
    private ByteBuf bodyByteBuf;
    private String method = "GET";
    private int maxRedirects = 10;
    private SSLContext sslContext;

    public RequestSpecBacking(MutableHeaders headers, URI uri, ByteBufAllocator byteBufAllocator, RequestParams requestParams) {
        this.headers = headers;
        this.uri = uri;
        this.byteBufAllocator = byteBufAllocator;
        this.requestParams = requestParams;
        this.bodyByteBuf = byteBufAllocator.buffer(0, 0);
        this.decompressResponse = true;
    }

    public String getMethod() {
        return this.method;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isDecompressResponse() {
        return this.decompressResponse;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ByteBuf getBody() {
        return this.bodyByteBuf;
    }

    public RequestSpec asSpec() {
        return new Spec();
    }

    private class Spec
    implements RequestSpec {
        private BodyImpl body = new BodyImpl();

        private Spec() {
        }

        @Override
        public RequestSpec redirects(int maxRedirects) {
            Preconditions.checkArgument((maxRedirects >= 0 ? 1 : 0) != 0);
            RequestSpecBacking.this.maxRedirects = maxRedirects;
            return this;
        }

        @Override
        public RequestSpec sslContext(SSLContext sslContext) {
            RequestSpecBacking.this.sslContext = sslContext;
            return this;
        }

        @Override
        public MutableHeaders getHeaders() {
            return RequestSpecBacking.this.headers;
        }

        @Override
        public RequestSpec headers(Action<? super MutableHeaders> action) throws Exception {
            action.execute(this.getHeaders());
            return this;
        }

        @Override
        public RequestSpec method(String method) {
            RequestSpecBacking.this.method = method.toUpperCase();
            return this;
        }

        @Override
        public RequestSpec decompressResponse(boolean shouldDecompress) {
            RequestSpecBacking.this.decompressResponse = shouldDecompress;
            return this;
        }

        @Override
        public URI getUrl() {
            return RequestSpecBacking.this.uri;
        }

        @Override
        public RequestSpec readTimeout(Duration duration) {
            ((RequestSpecBacking)RequestSpecBacking.this).requestParams.readTimeoutNanos = duration.toNanos();
            return this;
        }

        private void setBodyByteBuf(ByteBuf byteBuf) {
            if (RequestSpecBacking.this.bodyByteBuf != null) {
                RequestSpecBacking.this.bodyByteBuf.release();
            }
            RequestSpecBacking.this.bodyByteBuf = byteBuf;
        }

        @Override
        public RequestSpec.Body getBody() {
            return this.body;
        }

        @Override
        public RequestSpec body(Action<? super RequestSpec.Body> action) throws Exception {
            action.execute(this.getBody());
            return this;
        }

        private class BodyImpl
        implements RequestSpec.Body {
            private BodyImpl() {
            }

            @Override
            public RequestSpec.Body type(String contentType) {
                Spec.this.getHeaders().set(HttpHeaderConstants.CONTENT_TYPE, contentType);
                return this;
            }

            @Override
            public RequestSpec.Body stream(Action<? super OutputStream> action) throws Exception {
                ByteBuf byteBuf = RequestSpecBacking.this.byteBufAllocator.buffer();
                try (ByteBufOutputStream outputStream = new ByteBufOutputStream(byteBuf);){
                    action.execute((OutputStream)outputStream);
                }
                catch (Throwable t) {
                    byteBuf.release();
                    throw t;
                }
                Spec.this.setBodyByteBuf(byteBuf);
                return this;
            }

            @Override
            public RequestSpec.Body buffer(ByteBuf byteBuf) {
                Spec.this.setBodyByteBuf(byteBuf.retain());
                return this;
            }

            @Override
            public RequestSpec.Body bytes(byte[] bytes) {
                Spec.this.setBodyByteBuf(Unpooled.wrappedBuffer((byte[])bytes));
                return this;
            }

            @Override
            public RequestSpec.Body text(CharSequence text) {
                return this.text(text, CharsetUtil.UTF_8);
            }

            @Override
            public RequestSpec.Body text(CharSequence text, Charset charset) {
                if (charset.equals(CharsetUtil.UTF_8)) {
                    this.maybeSetContentType(HttpHeaderConstants.PLAIN_TEXT_UTF8);
                } else {
                    this.maybeSetContentType("text/plain;charset=" + charset.name());
                }
                Spec.this.setBodyByteBuf(Unpooled.copiedBuffer((CharSequence)text, (Charset)charset));
                return this;
            }

            private void maybeSetContentType(CharSequence s) {
                if (!RequestSpecBacking.this.headers.contains(HttpHeaderConstants.CONTENT_TYPE.toString())) {
                    RequestSpecBacking.this.headers.set(HttpHeaderConstants.CONTENT_TYPE, s);
                }
            }
        }
    }
}

