/*
 * Decompiled with CFR 0.152.
 */
package ratpack.jackson.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.OutputStream;
import ratpack.handling.Context;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.jackson.JsonRender;
import ratpack.render.RendererSupport;

public class JsonRenderer
extends RendererSupport<JsonRender> {
    private final ObjectWriter defaultObjectWriter;

    public JsonRenderer(ObjectWriter defaultObjectWriter) {
        this.defaultObjectWriter = defaultObjectWriter;
    }

    @Override
    public void render(Context context, JsonRender object) throws Exception {
        ObjectWriter writer = object.getObjectWriter();
        if (writer == null) {
            writer = this.defaultObjectWriter;
        }
        ByteBuf buffer = context.get(ByteBufAllocator.class).buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
        try {
            writer.writeValue((OutputStream)outputStream, object.getObject());
        }
        catch (JsonProcessingException e) {
            buffer.release();
            context.error(e);
            return;
        }
        context.getResponse().contentTypeIfNotSet(HttpHeaderConstants.JSON).send(buffer);
    }
}

