/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.config.internal.ConfigDataLoader;
import ratpack.exec.Blocking;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.registry.Registry;
import ratpack.server.ReloadInformant;
import ratpack.server.Service;
import ratpack.server.StartEvent;
import ratpack.server.StopEvent;

public class ConfigDataReloadInformant
implements ReloadInformant,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigDataReloadInformant.class);
    private static final Duration INTERVAL = Duration.ofSeconds(1L);
    private final ConfigDataLoader loader;
    private final ObjectNode currentNode;
    private boolean changeDetected;
    private boolean stopped;

    public ConfigDataReloadInformant(ObjectNode currentNode, ConfigDataLoader loader) {
        this.currentNode = currentNode;
        this.loader = loader;
    }

    @Override
    public boolean shouldReload(Registry registry) {
        return this.changeDetected;
    }

    private void schedulePoll() {
        if (this.shouldStop()) {
            return;
        }
        ExecController controller = Execution.current().getController();
        ScheduledExecutorService scheduledExecutorService = controller.getExecutor();
        Runnable poll = () -> controller.exec().start(e -> {
            if (this.shouldStop()) {
                return;
            }
            Blocking.get(this.loader::load).onError(error -> {
                LOGGER.warn("failed to load config in order to check for changes", error);
                this.schedulePoll();
            }).then(newNode -> {
                if (this.currentNode.equals(newNode)) {
                    LOGGER.debug("No difference in configuration data");
                    this.schedulePoll();
                } else {
                    LOGGER.info("Configuration data difference detected; next request should reload");
                    this.changeDetected = true;
                }
            });
        });
        scheduledExecutorService.schedule(poll, INTERVAL.getSeconds(), TimeUnit.SECONDS);
    }

    private boolean shouldStop() {
        return this.stopped || Execution.current().getController().getEventLoopGroup().isShuttingDown();
    }

    @Override
    public String toString() {
        return "configuration data reload informant";
    }

    @Override
    public void onStart(StartEvent event) throws Exception {
        this.schedulePoll();
    }

    @Override
    public void onStop(StopEvent event) throws Exception {
        this.stopped = true;
    }
}

