/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.module;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.server.ServerConfig;
import ratpack.server.internal.ServerConfigData;
import ratpack.server.internal.ServerEnvironment;

public class ServerConfigDataDeserializer
extends JsonDeserializer<ServerConfigData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConfigDataDeserializer.class);
    private final ServerEnvironment serverEnvironment;

    public ServerConfigDataDeserializer(ServerEnvironment serverEnvironment) {
        this.serverEnvironment = serverEnvironment;
    }

    public ServerConfigData deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = jp.getCodec();
        ObjectNode serverNode = (ObjectNode)jp.readValueAsTree();
        ServerConfigData data = new ServerConfigData(this.serverEnvironment);
        if (serverNode.hasNonNull("port")) {
            data.setPort(this.parsePort(serverNode.get("port")));
        }
        if (serverNode.hasNonNull("address")) {
            data.setAddress(ServerConfigDataDeserializer.toValue(codec, serverNode.get("address"), InetAddress.class));
        }
        if (serverNode.hasNonNull("development")) {
            data.setDevelopment(serverNode.get("development").asBoolean(false));
        }
        if (serverNode.hasNonNull("threads")) {
            data.setThreads(serverNode.get("threads").asInt(ServerConfig.DEFAULT_THREADS));
        }
        if (serverNode.hasNonNull("publicAddress")) {
            data.setPublicAddress(ServerConfigDataDeserializer.toValue(codec, serverNode.get("publicAddress"), URI.class));
        }
        if (serverNode.hasNonNull("maxContentLength")) {
            data.setMaxContentLength(serverNode.get("maxContentLength").asInt(0x100000));
        }
        if (serverNode.hasNonNull("ssl")) {
            data.setSslContext(ServerConfigDataDeserializer.toValue(codec, serverNode.get("ssl"), SSLContext.class));
        }
        if (serverNode.hasNonNull("requireClientSslAuth")) {
            data.setRequireClientSslAuth(serverNode.get("requireClientSslAuth").asBoolean(false));
        }
        if (serverNode.hasNonNull("baseDir")) {
            data.setBaseDir(ServerConfigDataDeserializer.toValue(codec, serverNode.get("baseDir"), Path.class));
        }
        if (serverNode.hasNonNull("connectTimeoutMillis")) {
            this.parseOptionalIntValue("connectTimeoutMillis", serverNode.get("connectTimeoutMillis")).ifPresent(data::setConnectTimeoutMillis);
        }
        if (serverNode.hasNonNull("maxMessagesPerRead")) {
            this.parseOptionalIntValue("maxMessagesPerRead", serverNode.get("maxMessagesPerRead")).ifPresent(data::setMaxMessagesPerRead);
        }
        if (serverNode.hasNonNull("receiveBufferSize")) {
            this.parseOptionalIntValue("receiveBufferSize", serverNode.get("receiveBufferSize")).ifPresent(data::setReceiveBufferSize);
        }
        if (serverNode.hasNonNull("writeSpinCount")) {
            this.parseOptionalIntValue("writeSpinCount", serverNode.get("writeSpinCount")).ifPresent(data::setWriteSpinCount);
        }
        return data;
    }

    private int parsePort(JsonNode node) {
        return node.isInt() ? node.asInt() : this.serverEnvironment.parsePortValue("config", node.asText()).intValue();
    }

    private static <T> T toValue(ObjectCodec codec, JsonNode node, Class<T> valueType) throws JsonProcessingException {
        Object pojo;
        if (node.isPojo() && valueType.isInstance(pojo = ((POJONode)node).getPojo())) {
            return valueType.cast(pojo);
        }
        return (T)codec.treeToValue((TreeNode)node, valueType);
    }

    public Optional<Integer> parseOptionalIntValue(String description, JsonNode node) {
        try {
            return Optional.of(Integer.parseInt(node.asText()));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse {} value {} to int", (Object)description, (Object)node.asText());
            return Optional.empty();
        }
    }
}

