/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecBuilder;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.exec.internal.ThreadBinding;
import ratpack.func.Action;
import ratpack.func.BiAction;
import ratpack.registry.RegistrySpec;
import ratpack.util.Exceptions;
import ratpack.util.internal.ChannelImplDetector;

public class DefaultExecController
implements ExecControllerInternal {
    private static final BiAction<Execution, Throwable> LOG_UNCAUGHT = (o, t) -> ExecutionBacking.LOGGER.error("Uncaught execution exception", t);
    private static final int MAX_ERRORS_THRESHOLD = 5;
    private final ExecutorService blockingExecutor;
    private final EventLoopGroup eventLoopGroup;
    private final int numThreads;
    private ImmutableList<? extends ExecInterceptor> interceptors = ImmutableList.of();

    public DefaultExecController() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public DefaultExecController(int numThreads) {
        this.numThreads = numThreads;
        this.eventLoopGroup = ChannelImplDetector.eventLoopGroup(numThreads, (ThreadFactory)((Object)new ExecControllerBindingThreadFactory(true, "ratpack-compute", 10)));
        this.blockingExecutor = Executors.newCachedThreadPool((ThreadFactory)((Object)new ExecControllerBindingThreadFactory(false, "ratpack-blocking", 5)));
    }

    @Override
    public void setDefaultInterceptors(ImmutableList<? extends ExecInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.blockingExecutor.shutdown();
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.eventLoopGroup;
    }

    @Override
    public ExecutorService getBlockingExecutor() {
        return this.blockingExecutor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public boolean isManagedThread() {
        return ThreadBinding.get().map(c -> c.getExecController() == this).orElse(false);
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public ExecBuilder exec() {
        return new ExecBuilder(){
            private BiAction<? super Execution, ? super Throwable> onError = DefaultExecController.access$000();
            private Action<? super Execution> onComplete = Action.noop();
            private Action<? super Execution> onStart = Action.noop();
            private Action<? super RegistrySpec> registry = Action.noop();
            private EventLoop eventLoop = DefaultExecController.this.getEventLoopGroup().next();

            @Override
            public ExecBuilder eventLoop(EventLoop eventLoop) {
                this.eventLoop = eventLoop;
                return this;
            }

            @Override
            public ExecBuilder onError(BiAction<? super Execution, ? super Throwable> onError) {
                LinkedList seen = Lists.newLinkedList();
                this.onError = (e, t) -> {
                    if (seen.size() < 5) {
                        seen.add(t);
                        onError.execute((Execution)e, (Throwable)t);
                    } else {
                        seen.forEach(t::addSuppressed);
                        ExecutionBacking.LOGGER.error("Error handler " + onError + "reached maximum error threshold (might be caught in an error loop)", t);
                    }
                };
                return this;
            }

            @Override
            public ExecBuilder onError(Action<? super Throwable> onError) {
                return this.onError((? super Execution e, ? super Throwable t) -> onError.execute((Throwable)t));
            }

            @Override
            public ExecBuilder onComplete(Action<? super Execution> onComplete) {
                this.onComplete = onComplete;
                return this;
            }

            @Override
            public ExecBuilder onStart(Action<? super Execution> onStart) {
                this.onStart = onStart;
                return this;
            }

            @Override
            public ExecBuilder register(Action<? super RegistrySpec> action) {
                this.registry = action;
                return this;
            }

            @Override
            public void start(Action<? super Execution> action) {
                if (this.eventLoop.inEventLoop() && ExecutionBacking.get() == null) {
                    Exceptions.uncheck(() -> new ExecutionBacking(DefaultExecController.this, this.eventLoop, (ImmutableList<? extends ExecInterceptor>)DefaultExecController.this.interceptors, this.registry, action, this.onError, this.onStart, this.onComplete));
                } else {
                    this.eventLoop.submit(() -> new ExecutionBacking(DefaultExecController.this, this.eventLoop, (ImmutableList<? extends ExecInterceptor>)DefaultExecController.this.interceptors, this.registry, action, this.onError, this.onStart, this.onComplete));
                }
            }
        };
    }

    static /* synthetic */ BiAction access$000() {
        return LOG_UNCAUGHT;
    }

    private class ExecControllerBindingThreadFactory
    extends DefaultThreadFactory {
        private final boolean compute;

        public ExecControllerBindingThreadFactory(boolean compute, String name, int priority) {
            super(name, priority);
            this.compute = compute;
        }

        public Thread newThread(Runnable r) {
            return super.newThread(() -> {
                ThreadBinding.bind(this.compute, DefaultExecController.this);
                r.run();
            });
        }
    }
}

