/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.reflect.TypeToken;
import io.netty.channel.EventLoop;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Block;
import ratpack.registry.internal.SimpleMutableRegistry;

public class DefaultExecution
extends SimpleMutableRegistry
implements Execution {
    private final ExecutionBacking executionBacking;
    private final EventLoop eventLoop;
    private final ExecController controller;
    private final List<AutoCloseable> closeables;

    public DefaultExecution(ExecutionBacking executionBacking, EventLoop eventLoop, ExecController controller, List<AutoCloseable> closeables) {
        this.executionBacking = executionBacking;
        this.eventLoop = eventLoop;
        this.controller = controller;
        this.closeables = closeables;
    }

    @Override
    public ExecController getController() {
        return this.controller;
    }

    @Override
    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    @Override
    public void onCleanup(AutoCloseable autoCloseable) {
        this.closeables.add(autoCloseable);
    }

    @Override
    public <O> Execution addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        super.addLazy(type, supplier);
        return this;
    }

    @Override
    public <O> Execution add(TypeToken<? super O> type, O object) {
        super.add(type, object);
        return this;
    }

    @Override
    public void addInterceptor(ExecInterceptor execInterceptor, Block continuation) throws Exception {
        this.executionBacking.addInterceptor(execInterceptor);
        this.executionBacking.intercept(ExecInterceptor.ExecType.COMPUTE, Collections.singletonList(execInterceptor).iterator(), continuation);
    }
}

