/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.event.internal.EventRegistry;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.ByContentSpec;
import ratpack.handling.ByMethodSpec;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Redirector;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.ContentNegotiationHandler;
import ratpack.handling.internal.DefaultByContentSpec;
import ratpack.handling.internal.DefaultByMethodSpec;
import ratpack.handling.internal.HandlerException;
import ratpack.handling.internal.MultiMethodHandler;
import ratpack.handling.internal.ThrowableHolder;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.TypedData;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.parse.NoSuchParserException;
import ratpack.parse.Parse;
import ratpack.parse.Parser;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.path.internal.DefaultPathTokens;
import ratpack.path.internal.RootPathBinding;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.DelegatingRegistry;
import ratpack.render.NoSuchRendererException;
import ratpack.render.internal.RenderController;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;
import ratpack.util.Types;

public class DefaultContext
implements Context {
    private static final TypeToken<Parser<?>> PARSER_TYPE_TOKEN = new TypeToken<Parser<?>>(){};
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultContext.class);
    private final RequestConstants requestConstants;
    private final Registry joinedRegistry;

    public static void start(EventLoop eventLoop, RequestConstants requestConstants, Registry registry, Handler[] handlers, Action<? super Execution> onComplete) {
        RootPathBinding initialPathBinding = new RootPathBinding(requestConstants.request.getPath());
        Registry pathBindingRegistry = Registry.single(PathBinding.class, initialPathBinding);
        ChainIndex index = new ChainIndex(handlers, registry.join(pathBindingRegistry), true);
        requestConstants.indexes.push(index);
        DefaultContext context = new DefaultContext(requestConstants);
        requestConstants.context = context;
        requestConstants.applicationConstants.execController.exec().onError(throwable -> requestConstants.context.error(throwable instanceof HandlerException ? throwable.getCause() : throwable)).onComplete(onComplete).register(s -> s.add(Context.class, context).add(Request.class, requestConstants.request).add(Response.class, requestConstants.response)).eventLoop(eventLoop).onStart(e -> DefaultRequest.setDelegateRegistry(requestConstants.request, e)).start(e -> {
            requestConstants.execution = e;
            context.next();
        });
    }

    public DefaultContext(RequestConstants requestConstants) {
        this.requestConstants = requestConstants;
        this.joinedRegistry = ((DelegatingRegistry)this::getContextRegistry).join(requestConstants.request);
    }

    private Registry getContextRegistry() {
        return ((ChainIndex)((RequestConstants)this.requestConstants).indexes.peek()).registry;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public Execution getExecution() {
        return this.requestConstants.execution;
    }

    @Override
    public ServerConfig getServerConfig() {
        return this.requestConstants.applicationConstants.serverConfig;
    }

    @Override
    public Request getRequest() {
        return this.requestConstants.request;
    }

    @Override
    public Response getResponse() {
        return this.requestConstants.response;
    }

    @Override
    public void next() {
        Handler handler = null;
        ChainIndex index = (ChainIndex)this.requestConstants.indexes.peek();
        while (handler == null) {
            if (index.hasNext()) {
                handler = index.next();
                if (!handler.getClass().equals(ChainHandler.class)) continue;
                this.requestConstants.indexes.push(new ChainIndex(((ChainHandler)handler).getHandlers(), this.getContextRegistry(), false));
                index = (ChainIndex)this.requestConstants.indexes.peek();
                handler = null;
                continue;
            }
            if (index.first) {
                handler = this.requestConstants.applicationConstants.end;
                continue;
            }
            this.requestConstants.indexes.pop();
            index = (ChainIndex)this.requestConstants.indexes.peek();
        }
        try {
            this.requestConstants.handler = handler;
            handler.handle(this);
        }
        catch (Throwable e) {
            if (e instanceof HandlerException) {
                throw (HandlerException)e;
            }
            throw new HandlerException(e);
        }
    }

    @Override
    public void next(Registry registry) {
        ((ChainIndex)((RequestConstants)this.requestConstants).indexes.peek()).registry = this.getContextRegistry().join(registry);
        this.next();
    }

    @Override
    public void insert(Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.requestConstants.indexes.push(new ChainIndex(handlers, this.getContextRegistry(), false));
        this.next();
    }

    @Override
    public void insert(Registry registry, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.requestConstants.indexes.push(new ChainIndex(handlers, this.getContextRegistry().join(registry), false));
        this.next();
    }

    @Override
    public PathTokens getPathTokens() {
        return this.maybeGet(PathBinding.class).map(PathBinding::getTokens).orElseGet(DefaultPathTokens::empty);
    }

    @Override
    public PathTokens getAllPathTokens() {
        return this.get(PathBinding.class).getAllTokens();
    }

    @Override
    public Path file(String path) {
        return this.get(FileSystemBinding.class).file(path);
    }

    @Override
    public void render(Object object) throws NoSuchRendererException {
        try {
            this.requestConstants.applicationConstants.renderController.render(object, this);
        }
        catch (NoSuchRendererException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public <T, O> Promise<T> parse(Parse<T, O> parse) {
        return this.getRequest().getBody().map(b -> this.parse((TypedData)b, parse));
    }

    @Override
    public <T, O> T parse(TypedData body, Parse<T, O> parse) {
        String requestContentType = body.getContentType().getType();
        if (requestContentType == null) {
            requestContentType = "text/plain";
        }
        String finalRequestContentType = requestContentType;
        return Exceptions.uncheck(() -> this.joinedRegistry.first(PARSER_TYPE_TOKEN, (? super T parser) -> {
            if (parser.getContentType().equalsIgnoreCase(finalRequestContentType) && parser.getOptsType().isInstance(parse.getOpts())) {
                Parser cast = (Parser)Types.cast(parser);
                return cast.parse(this, body, parse);
            }
            return null;
        })).orElseThrow(() -> new NoSuchParserException(parse.getType(), parse.getOpts(), finalRequestContentType));
    }

    @Override
    public <T> Promise<T> parse(Class<T> type) {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T> Promise<T> parse(TypeToken<T> type) {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T, O> Promise<T> parse(Class<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public <T, O> Promise<T> parse(TypeToken<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public void onClose(Action<? super RequestOutcome> callback) {
        this.requestConstants.onCloseRegistry.register(callback);
    }

    @Override
    public DirectChannelAccess getDirectChannelAccess() {
        return this.requestConstants.directChannelAccess;
    }

    @Override
    public void redirect(String location) {
        this.redirect(HttpResponseStatus.FOUND.code(), location);
    }

    @Override
    public void redirect(int code, String location) {
        Redirector redirector = this.joinedRegistry.get(Redirector.class);
        redirector.redirect(this, location, code);
    }

    @Override
    public void lastModified(Date date, Runnable runnable) {
        long time;
        long ifModifiedSinceSecs;
        Date ifModifiedSinceHeader = this.requestConstants.request.getHeaders().getDate((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        long lastModifiedSecs = date.getTime() / 1000L;
        if (ifModifiedSinceHeader != null && lastModifiedSecs == (ifModifiedSinceSecs = (time = ifModifiedSinceHeader.getTime()) / 1000L)) {
            this.requestConstants.response.status(HttpResponseStatus.NOT_MODIFIED.code()).send();
            return;
        }
        this.requestConstants.response.getHeaders().setDate(HttpHeaderConstants.LAST_MODIFIED, date);
        runnable.run();
    }

    @Override
    public void error(Throwable throwable) {
        ServerErrorHandler serverErrorHandler = this.get(ServerErrorHandler.class);
        throwable = this.unpackThrowable(throwable);
        ThrowableHolder throwableHolder = this.getRequest().maybeGet(ThrowableHolder.class).orElse(null);
        if (throwableHolder == null) {
            this.getRequest().add(ThrowableHolder.class, (Object)new ThrowableHolder(throwable));
            try {
                serverErrorHandler.error(this, throwable);
            }
            catch (Throwable errorHandlerThrowable) {
                this.onErrorHandlerError(serverErrorHandler, throwable, errorHandlerThrowable);
            }
        } else {
            this.onErrorHandlerError(serverErrorHandler, throwableHolder.getThrowable(), throwable);
        }
    }

    private void onErrorHandlerError(ServerErrorHandler serverErrorHandler, Throwable original, Throwable errorHandlerThrowable) {
        String msg = "Throwable thrown by error handler " + serverErrorHandler + " while handling throwable\n" + "Original throwable: " + Throwables.getStackTraceAsString((Throwable)original) + "\n" + "Error handler throwable: " + Throwables.getStackTraceAsString((Throwable)errorHandlerThrowable);
        LOGGER.error(msg);
        Response response = this.requestConstants.response.status(500);
        if (this.getServerConfig().isDevelopment()) {
            response.send(msg);
        } else {
            response.send();
        }
    }

    private Throwable unpackThrowable(Throwable throwable) {
        if (throwable instanceof UndeclaredThrowableException) {
            return throwable.getCause();
        }
        return throwable;
    }

    @Override
    public void clientError(int statusCode) {
        try {
            this.get(ClientErrorHandler.class).error(this, statusCode);
        }
        catch (Throwable e) {
            this.error(Exceptions.toException(e));
        }
    }

    @Override
    public void byMethod(Action<? super ByMethodSpec> action) throws Exception {
        LinkedHashMap blocks = Maps.newLinkedHashMap();
        DefaultByMethodSpec spec = new DefaultByMethodSpec(blocks);
        action.execute(spec);
        new MultiMethodHandler(blocks).handle(this);
    }

    @Override
    public void byContent(Action<? super ByContentSpec> action) throws Exception {
        LinkedHashMap blocks = Maps.newLinkedHashMap();
        DefaultByContentSpec spec = new DefaultByContentSpec(blocks);
        action.execute(spec);
        new ContentNegotiationHandler(blocks, spec.getNoMatchHandler()).handle(this);
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        return this.joinedRegistry.get(type);
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        return this.joinedRegistry.maybeGet(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.joinedRegistry.getAll(type);
    }

    @Override
    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        return this.joinedRegistry.first(type, function);
    }

    private static class ChainIndex
    implements Iterator<Handler> {
        final Handler[] handlers;
        Registry registry;
        final boolean first;
        int i;

        private ChainIndex(Handler[] handlers, Registry registry, boolean first) {
            this.handlers = handlers;
            this.registry = registry;
            this.first = first;
        }

        @Override
        public Handler next() {
            return this.handlers[this.i++];
        }

        @Override
        public boolean hasNext() {
            return this.i < this.handlers.length;
        }
    }

    public static class RequestConstants {
        private final ApplicationConstants applicationConstants;
        private final DefaultRequest request;
        private final DirectChannelAccess directChannelAccess;
        private final EventRegistry<RequestOutcome> onCloseRegistry;
        private Execution execution;
        private final Deque<ChainIndex> indexes = Lists.newLinkedList();
        public Response response;
        public Context context;
        public Handler handler;

        public RequestConstants(ApplicationConstants applicationConstants, DefaultRequest request, DirectChannelAccess directChannelAccess, EventRegistry<RequestOutcome> onCloseRegistry) {
            this.applicationConstants = applicationConstants;
            this.request = request;
            this.directChannelAccess = directChannelAccess;
            this.onCloseRegistry = onCloseRegistry;
        }
    }

    public static class ApplicationConstants {
        private final RenderController renderController;
        private final ExecController execController;
        private final ServerConfig serverConfig;
        private final Handler end;

        public ApplicationConstants(Registry registry, RenderController renderController, ExecController execController, Handler end) {
            this.renderController = renderController;
            this.execController = execController;
            this.serverConfig = registry.get(ServerConfig.class);
            this.end = end;
        }
    }
}

