/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.net.HostAndPort;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import ratpack.auth.UserIdentifier;
import ratpack.handling.Context;
import ratpack.handling.RequestId;
import ratpack.handling.RequestLog;
import ratpack.handling.RequestOutcome;
import ratpack.http.HttpMethod;
import ratpack.http.Request;
import ratpack.http.SentResponse;
import ratpack.http.Status;
import ratpack.http.internal.HttpHeaderConstants;

public class DefaultRequestLog
implements RequestLog {
    private static final String DEFAULT_FORMAT = "dd/MMM/yyyy:HH:mm:ss Z";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z").withZone(ZoneId.systemDefault());

    @Override
    public String format(Context ctx, RequestOutcome outcome) {
        Request request = outcome.getRequest();
        SentResponse response = outcome.getResponse();
        String responseSize = "-";
        String contentLength = response.getHeaders().get(HttpHeaderConstants.CONTENT_LENGTH);
        if (contentLength != null) {
            responseSize = contentLength;
        }
        StringBuilder logLine = new StringBuilder().append(this.ncsaLogFormat(request.getRemoteAddress(), "-", request.maybeGet(UserIdentifier.class), request.getTimestamp(), request.getMethod(), "/" + request.getPath(), request.getProtocol(), outcome.getResponse().getStatus(), responseSize));
        request.maybeGet(RequestId.class).ifPresent(id1 -> {
            logLine.append(" id=");
            logLine.append(id1.getId());
        });
        return logLine.toString();
    }

    String ncsaLogFormat(HostAndPort client, String rfc1413Ident, Optional<UserIdentifier> userId, Instant timestamp, HttpMethod method, String uri, String httpProtocol, Status status, String responseSize) {
        return String.format("%s %s %s [%s] \"%s %s %s\" %d %s", client.getHostText(), rfc1413Ident, userId.isPresent() ? userId.get().getUserIdentifier() : "-", this.formatter.format(timestamp), method.getName(), uri, httpProtocol, status.getCode(), responseSize);
    }
}

