/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import com.google.common.reflect.TypeToken;
import java.util.function.Supplier;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.util.Types;

public interface RegistrySpec {
    default public <O> RegistrySpec add(Class<? super O> type, O object) {
        return this.add(TypeToken.of(type), object);
    }

    default public <O> RegistrySpec add(TypeToken<? super O> type, O object) {
        return this.addLazy(type, () -> object);
    }

    default public RegistrySpec add(Object object) {
        TypeToken type = TypeToken.of(object.getClass());
        return this.add(type, object);
    }

    default public <O> RegistrySpec addLazy(Class<O> type, Supplier<? extends O> supplier) {
        return this.addLazy(TypeToken.of(type), supplier);
    }

    public <O> RegistrySpec addLazy(TypeToken<O> var1, Supplier<? extends O> var2);

    default public <O> RegistrySpec addLazyAsync(Class<O> type, Supplier<? extends Promise<? extends O>> supplier) {
        return this.addLazy(Types.promiseOf(type), (Supplier)Types.cast(supplier));
    }

    default public <O> RegistrySpec addLazyAsync(TypeToken<O> type, Supplier<? extends Promise<? extends O>> supplier) {
        return this.addLazy(Types.promiseOf(type), (Supplier)Types.cast(supplier));
    }

    default public RegistrySpec with(Action<? super RegistrySpec> action) throws Exception {
        return action.with(this);
    }
}

