/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import ratpack.config.ConfigData;
import ratpack.config.ConfigDataBuilder;
import ratpack.config.ConfigObject;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.config.internal.DefaultConfigData;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.server.internal.DefaultServerConfig;

public class DefaultServerConfigBuilder
implements ServerConfigBuilder {
    private final ConfigDataBuilder configDataBuilder;
    private final ObjectNode serverConfigData;
    private final Map<String, Class<?>> required = Maps.newHashMap();

    public DefaultServerConfigBuilder(ConfigDataBuilder configDataBuilder) {
        this.configDataBuilder = configDataBuilder;
        this.serverConfigData = this.getObjectMapper().createObjectNode();
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.configDataBuilder.getObjectMapper();
    }

    @Override
    public ServerConfigBuilder baseDir(Path baseDir) {
        this.serverConfigData.putPOJO("baseDir", (Object)baseDir);
        return this;
    }

    @Override
    public ServerConfigBuilder port(int port) {
        this.serverConfigData.put("port", port);
        return this;
    }

    @Override
    public ServerConfigBuilder address(InetAddress address) {
        this.serverConfigData.putPOJO("address", (Object)address);
        return this;
    }

    @Override
    public ServerConfigBuilder development(boolean development) {
        this.serverConfigData.put("development", development);
        return this;
    }

    @Override
    public ServerConfigBuilder threads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("'threads' must be > 0");
        }
        this.serverConfigData.put("threads", threads);
        return this;
    }

    @Override
    public ServerConfigBuilder publicAddress(URI publicAddress) {
        this.serverConfigData.putPOJO("publicAddress", (Object)publicAddress);
        return this;
    }

    @Override
    public ServerConfigBuilder maxContentLength(int maxContentLength) {
        this.serverConfigData.put("maxContentLength", maxContentLength);
        return this;
    }

    @Override
    public ServerConfigBuilder connectTimeoutMillis(int connectTimeoutMillis) {
        this.serverConfigData.put("connectTimeoutMillis", connectTimeoutMillis);
        return this;
    }

    @Override
    public ServerConfigBuilder maxMessagesPerRead(int maxMessagesPerRead) {
        this.serverConfigData.put("maxMessagesPerRead", maxMessagesPerRead);
        return this;
    }

    @Override
    public ServerConfigBuilder receiveBufferSize(int receiveBufferSize) {
        this.serverConfigData.put("receiveBufferSize", receiveBufferSize);
        return this;
    }

    @Override
    public ServerConfigBuilder writeSpinCount(int writeSpinCount) {
        this.serverConfigData.put("writeSpinCount", writeSpinCount);
        return this;
    }

    @Override
    public ServerConfigBuilder ssl(SSLContext sslContext) {
        this.serverConfigData.putPOJO("ssl", (Object)sslContext);
        return this;
    }

    @Override
    public ServerConfigBuilder requireClientSslAuth(boolean requireClientSslAuth) {
        this.serverConfigData.put("requireClientSslAuth", requireClientSslAuth);
        return this;
    }

    @Override
    public ServerConfigBuilder configureObjectMapper(Action<ObjectMapper> action) {
        this.configDataBuilder.configureObjectMapper(action);
        return this;
    }

    @Override
    public ServerConfigBuilder add(ConfigSource configSource) {
        this.configDataBuilder.add(configSource);
        return this;
    }

    @Override
    public ServerConfigBuilder env(String prefix, Function<String, String> mapFunc) {
        this.configDataBuilder.env(prefix, mapFunc);
        return this;
    }

    @Override
    public ServerConfigBuilder env(EnvironmentParser environmentParser) {
        this.configDataBuilder.env(environmentParser);
        return this;
    }

    @Override
    public ServerConfigBuilder env() {
        this.configDataBuilder.env();
        return this;
    }

    @Override
    public ServerConfigBuilder env(String prefix) {
        this.configDataBuilder.env(prefix);
        return this;
    }

    @Override
    public ServerConfigBuilder json(ByteSource byteSource) {
        this.configDataBuilder.json(byteSource);
        return this;
    }

    @Override
    public ServerConfigBuilder json(Path path) {
        this.configDataBuilder.json(path);
        return this;
    }

    @Override
    public ServerConfigBuilder json(URL url) {
        this.configDataBuilder.json(url);
        return this;
    }

    @Override
    public ServerConfigBuilder props(ByteSource byteSource) {
        this.configDataBuilder.props(byteSource);
        return this;
    }

    @Override
    public ServerConfigBuilder props(Path path) {
        this.configDataBuilder.props(path);
        return this;
    }

    @Override
    public ServerConfigBuilder props(Properties properties) {
        this.configDataBuilder.props(properties);
        return this;
    }

    @Override
    public ServerConfigBuilder props(URL url) {
        this.configDataBuilder.props(url);
        return this;
    }

    @Override
    public ServerConfigBuilder props(Map<String, String> map) {
        this.configDataBuilder.props(map);
        return this;
    }

    @Override
    public ServerConfigBuilder sysProps() {
        this.configDataBuilder.sysProps();
        return this;
    }

    @Override
    public ServerConfigBuilder sysProps(String prefix) {
        this.configDataBuilder.sysProps(prefix);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(ByteSource byteSource) {
        this.configDataBuilder.yaml(byteSource);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(Path path) {
        this.configDataBuilder.yaml(path);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(URL url) {
        this.configDataBuilder.yaml(url);
        return this;
    }

    @Override
    public ServerConfigBuilder require(String pointer, Class<?> type) {
        Class<?> previous = this.required.put(Objects.requireNonNull(pointer, "pointer cannot be null"), Objects.requireNonNull(type, "type cannot be null"));
        if (previous != null) {
            throw new IllegalArgumentException("Cannot require config of type '" + type + "' at '" + pointer + "' as '" + previous + " has already been registered for this path");
        }
        return this;
    }

    @Override
    public ServerConfigBuilder onError(Action<? super Throwable> errorHandler) {
        this.configDataBuilder.onError(errorHandler);
        return this;
    }

    @Override
    public ServerConfigBuilder json(String path) {
        this.configDataBuilder.json(path);
        return this;
    }

    @Override
    public ServerConfigBuilder props(String path) {
        this.configDataBuilder.props(path);
        return this;
    }

    @Override
    public ServerConfigBuilder yaml(String path) {
        this.configDataBuilder.yaml(path);
        return this;
    }

    @Override
    public ImmutableList<ConfigSource> getConfigSources() {
        return this.configDataBuilder.getConfigSources();
    }

    @Override
    public ServerConfig build() {
        DefaultConfigData configData = new DefaultConfigData(this.configDataBuilder.getObjectMapper(), Iterables.concat(this.getConfigSources(), Collections.singleton(mapper -> {
            ObjectNode node = mapper.createObjectNode();
            node.putObject("server").setAll(this.serverConfigData);
            return node;
        })));
        ImmutableSet<ConfigObject<?>> requiredConfig = DefaultServerConfigBuilder.extractRequiredConfig(configData, this.required);
        return new DefaultServerConfig(configData, requiredConfig);
    }

    private static ImmutableSet<ConfigObject<?>> extractRequiredConfig(ConfigData configData, Map<String, Class<?>> required) {
        IllegalStateException badConfig = new IllegalStateException("Failed to build required config items");
        ImmutableSet.Builder config = ImmutableSet.builder();
        for (Map.Entry<String, Class<?>> requiredConfig : required.entrySet()) {
            String path = requiredConfig.getKey();
            Class<?> type = requiredConfig.getValue();
            try {
                config.add(configData.getAsConfigObject(path, type));
            }
            catch (Exception e) {
                badConfig.addSuppressed(new IllegalStateException("Could not bind config at '" + path + "' to '" + type + "'", e));
            }
        }
        if (badConfig.getSuppressed().length > 0) {
            throw badConfig;
        }
        return config.build();
    }
}

