/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetAddress;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import ratpack.background.internal.DefaultBackground;
import ratpack.file.FileSystemBinding;
import ratpack.handling.Background;
import ratpack.handling.Context;
import ratpack.handling.Foreground;
import ratpack.handling.internal.DefaultForeground;
import ratpack.launch.HandlerFactory;
import ratpack.launch.internal.LaunchConfigInternal;

public class DefaultLaunchConfig
implements LaunchConfigInternal {
    private final FileSystemBinding baseDir;
    private final HandlerFactory handlerFactory;
    private final int port;
    private final InetAddress address;
    private final boolean reloadable;
    private final int threads;
    private final ListeningExecutorService backgroundExecutorService;
    private final Background background;
    private final Foreground foreground;
    private final ByteBufAllocator byteBufAllocator;
    private final URI publicAddress;
    private final ImmutableList<String> indexFiles;
    private final ImmutableMap<String, String> other;
    private final SSLContext sslContext;
    private final int maxContentLength;
    private final ThreadLocal<Context> contextThreadLocal = new ThreadLocal();
    private final EventLoopGroup eventLoopGroup;

    public DefaultLaunchConfig(FileSystemBinding baseDir, int port, InetAddress address, boolean reloadable, int threads, ExecutorService backgroundExecutorService, ByteBufAllocator byteBufAllocator, URI publicAddress, ImmutableList<String> indexFiles, ImmutableMap<String, String> other, SSLContext sslContext, int maxContentLength, HandlerFactory handlerFactory) {
        this.baseDir = baseDir;
        this.port = port;
        this.address = address;
        this.reloadable = reloadable;
        this.threads = threads;
        this.backgroundExecutorService = MoreExecutors.listeningDecorator((ExecutorService)backgroundExecutorService);
        this.byteBufAllocator = byteBufAllocator;
        this.publicAddress = publicAddress;
        this.indexFiles = indexFiles;
        this.other = other;
        this.handlerFactory = handlerFactory;
        this.sslContext = sslContext;
        this.maxContentLength = maxContentLength;
        this.eventLoopGroup = new NioEventLoopGroup(threads, (ThreadFactory)new DefaultThreadFactory("ratpack-group"));
        this.background = new DefaultBackground((ExecutorService)this.eventLoopGroup, this.backgroundExecutorService, this.contextThreadLocal);
        this.foreground = new DefaultForeground(this.contextThreadLocal, MoreExecutors.listeningDecorator((ScheduledExecutorService)this.eventLoopGroup));
    }

    @Override
    public FileSystemBinding getBaseDir() {
        return this.baseDir;
    }

    @Override
    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean isReloadable() {
        return this.reloadable;
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    @Override
    public Background getBackground() {
        return this.background;
    }

    @Override
    public Foreground getForeground() {
        return this.foreground;
    }

    @Override
    public ByteBufAllocator getBufferAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public URI getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public List<String> getIndexFiles() {
        return this.indexFiles;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public String getOther(String key, String defaultValue) {
        String value = (String)this.other.get((Object)key);
        return value == null ? defaultValue : value;
    }

    @Override
    public Map<String, String> getOtherPrefixedWith(String prefix) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int prefixLength = prefix.length();
        for (Map.Entry property : this.other.entrySet()) {
            String key = (String)property.getKey();
            if (!key.startsWith(prefix) || key.length() <= prefixLength) continue;
            result.put(key.substring(prefixLength), (String)property.getValue());
        }
        return result;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public ThreadLocal<Context> getContextThreadLocal() {
        return this.contextThreadLocal;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public ExecutorService getBackgroundExecutorService() {
        return this.backgroundExecutorService;
    }
}

