/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.event.internal.EventRegistry;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.handling.Background;
import ratpack.handling.ByContentHandler;
import ratpack.handling.ByMethodHandler;
import ratpack.handling.Context;
import ratpack.handling.Foreground;
import ratpack.handling.Handler;
import ratpack.handling.ProcessingInterceptor;
import ratpack.handling.Redirector;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.handling.internal.ContextStorage;
import ratpack.handling.internal.DefaultByContentHandler;
import ratpack.handling.internal.DefaultByMethodHandler;
import ratpack.handling.internal.HandlerException;
import ratpack.handling.internal.InterceptedOperation;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.parse.NoSuchParserException;
import ratpack.parse.Parse;
import ratpack.parse.Parser;
import ratpack.parse.ParserException;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.promise.SuccessOrErrorPromise;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.render.NoSuchRendererException;
import ratpack.render.internal.RenderController;
import ratpack.server.BindAddress;
import ratpack.util.ExceptionUtils;
import ratpack.util.Result;
import ratpack.util.ResultAction;

public class DefaultContext
implements Context {
    private static final Logger LOGGER = Logger.getLogger(Context.class.getName());
    private final RequestConstants requestConstants;
    private final Registry registry;
    private final Handler[] nextHandlers;
    private final int nextIndex;
    private final Handler exhausted;

    public DefaultContext(RequestConstants requestConstants, Registry registry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        this.requestConstants = requestConstants;
        this.registry = registry;
        this.nextHandlers = nextHandlers;
        this.nextIndex = nextIndex;
        this.exhausted = exhausted;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public Request getRequest() {
        return this.requestConstants.request;
    }

    @Override
    public Response getResponse() {
        return this.requestConstants.response;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public void next() {
        this.doNext(this, this.registry, this.nextIndex, this.nextHandlers, this.exhausted);
    }

    @Override
    public void next(Registry registry) {
        List<ProcessingInterceptor> interceptors = registry.getAll(ProcessingInterceptor.class);
        final Registry joinedRegistry = Registries.join(this.registry, registry);
        for (ProcessingInterceptor interceptor : interceptors) {
            try {
                interceptor.init(this);
            }
            catch (Exception e) {
                DefaultContext context = this.createContext(joinedRegistry, this.nextHandlers, this.nextIndex, this.exhausted);
                throw new HandlerException(context, e);
            }
        }
        new InterceptedOperation(ProcessingInterceptor.Type.FOREGROUND, interceptors, this){

            @Override
            protected void performOperation() {
                DefaultContext.this.doNext(DefaultContext.this, joinedRegistry, DefaultContext.this.nextIndex, DefaultContext.this.nextHandlers, new RejoinHandler());
            }
        }.run();
    }

    @Override
    public void insert(Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.doNext(this, this.registry, 0, handlers, new RejoinHandler());
    }

    @Override
    public void insert(Registry registry, final Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        final Registry joinedRegistry = Registries.join(this.registry, registry);
        List<ProcessingInterceptor> interceptors = registry.getAll(ProcessingInterceptor.class);
        for (ProcessingInterceptor interceptor : interceptors) {
            try {
                interceptor.init(this);
            }
            catch (Exception e) {
                DefaultContext context = this.createContext(joinedRegistry, this.nextHandlers, this.nextIndex, this.exhausted);
                throw new HandlerException(context, e);
            }
        }
        new InterceptedOperation(ProcessingInterceptor.Type.FOREGROUND, interceptors, this){

            @Override
            protected void performOperation() {
                DefaultContext.this.doNext(DefaultContext.this, joinedRegistry, 0, handlers, new RejoinHandler());
            }
        }.run();
    }

    @Override
    public void respond(Handler handler) {
        try {
            handler.handle(this);
        }
        catch (Exception e) {
            this.dispatchException(e);
        }
    }

    @Override
    public PathTokens getPathTokens() {
        return this.get(PathBinding.class).getTokens();
    }

    @Override
    public PathTokens getAllPathTokens() {
        return this.get(PathBinding.class).getAllTokens();
    }

    @Override
    public Path file(String path) {
        return this.get(FileSystemBinding.class).file(path);
    }

    @Override
    public void render(Object object) throws NoSuchRendererException {
        this.requestConstants.applicationConstants.renderController.render(object, this);
    }

    @Override
    public <T, O> T parse(Parse<T, O> parse) throws ParserException, NoSuchParserException {
        List<Parser> all = this.registry.getAll(Parser.class);
        String requestContentType = this.requestConstants.request.getBody().getContentType().getType();
        if (requestContentType == null) {
            requestContentType = "text/plain";
        }
        for (Parser parser : all) {
            T parsed = this.maybeParse(requestContentType, parser, parse);
            if (parsed == null) continue;
            return parsed;
        }
        throw new NoSuchParserException(parse.getType(), parse.getOpts(), requestContentType);
    }

    @Override
    public <T> T parse(Class<T> type) throws NoSuchParserException, ParserException {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T, O> T parse(Class<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    private <T, O> T maybeParse(String requestContentType, Parser<?> parser, Parse<T, O> parse) throws ParserException {
        Class<?> optsType = parser.getOptsType();
        String contentType = parser.getContentType();
        if (requestContentType.equalsIgnoreCase(contentType) && optsType.isInstance(parse.getOpts())) {
            Parser<?> castParser = parser;
            try {
                return castParser.parse(this, this.getRequest().getBody(), parse);
            }
            catch (Exception e) {
                throw new ParserException(parser, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void onClose(Action<? super RequestOutcome> callback) {
        this.requestConstants.onCloseRegistry.register(callback);
    }

    @Override
    public DirectChannelAccess getDirectChannelAccess() {
        return this.requestConstants.directChannelAccess;
    }

    @Override
    public Background getBackground() {
        return this.requestConstants.applicationConstants.background;
    }

    @Override
    public Foreground getForeground() {
        return this.requestConstants.applicationConstants.foreground;
    }

    @Override
    public <T> SuccessOrErrorPromise<T> background(Callable<T> backgroundOperation) {
        return this.getBackground().exec(backgroundOperation);
    }

    @Override
    public void redirect(String location) {
        this.redirect(HttpResponseStatus.FOUND.code(), location);
    }

    @Override
    public void redirect(int code, String location) {
        Redirector redirector = this.registry.get(Redirector.class);
        redirector.redirect(this, location, code);
    }

    @Override
    public void lastModified(Date date, Runnable runnable) {
        long time;
        long ifModifiedSinceSecs;
        Date ifModifiedSinceHeader = this.requestConstants.request.getHeaders().getDate("If-Modified-Since");
        long lastModifiedSecs = date.getTime() / 1000L;
        if (ifModifiedSinceHeader != null && lastModifiedSecs == (ifModifiedSinceSecs = (time = ifModifiedSinceHeader.getTime()) / 1000L)) {
            this.requestConstants.response.status(HttpResponseStatus.NOT_MODIFIED.code(), HttpResponseStatus.NOT_MODIFIED.reasonPhrase()).send();
            return;
        }
        this.requestConstants.response.getHeaders().setDate(HttpHeaderConstants.LAST_MODIFIED, date);
        runnable.run();
    }

    @Override
    public BindAddress getBindAddress() {
        return this.requestConstants.bindAddress;
    }

    @Override
    public void error(Exception exception) {
        ServerErrorHandler serverErrorHandler = this.get(ServerErrorHandler.class);
        Exception unpacked = this.unpackException(exception);
        try {
            serverErrorHandler.error(this, unpacked);
        }
        catch (Exception errorHandlerException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            stringWriter.append("Exception thrown by error handler ").append(serverErrorHandler.toString()).append(" while handling exception\nOriginal exception: ");
            unpacked.printStackTrace(printWriter);
            stringWriter.append("Error handler exception: ");
            errorHandlerException.printStackTrace(printWriter);
            LOGGER.warning(stringWriter.toString());
            this.requestConstants.response.status(500).send();
        }
    }

    private Exception unpackException(Exception exception) {
        if (exception instanceof UndeclaredThrowableException) {
            return ExceptionUtils.toException(exception.getCause());
        }
        return exception;
    }

    @Override
    public void clientError(int statusCode) {
        try {
            this.get(ClientErrorHandler.class).error(this, statusCode);
        }
        catch (Exception e) {
            this.dispatchException(e);
        }
    }

    @Override
    public void withErrorHandling(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            this.dispatchException(e);
        }
    }

    private void dispatchException(Exception e) {
        if (e instanceof HandlerException) {
            ((HandlerException)e).getContext().error((Exception)e.getCause());
        } else {
            this.error(e);
        }
    }

    @Override
    public <T> ResultAction<T> resultAction(final Action<T> action) {
        return new ResultAction<T>(){

            @Override
            public void execute(Result<T> result) {
                if (result.isFailure()) {
                    DefaultContext.this.dispatchException(result.getFailure());
                } else {
                    try {
                        action.execute(result.getValue());
                    }
                    catch (Exception e) {
                        DefaultContext.this.dispatchException(e);
                    }
                }
            }
        };
    }

    @Override
    public ByMethodHandler getByMethod() {
        return new DefaultByMethodHandler();
    }

    @Override
    public ByContentHandler getByContent() {
        return new DefaultByContentHandler();
    }

    protected void doNext(Context parentContext, Registry registry, int nextIndex, Handler[] nextHandlers, Handler exhausted) {
        Handler handler;
        Context context;
        if (nextIndex >= nextHandlers.length) {
            context = parentContext;
            handler = exhausted;
        } else {
            handler = nextHandlers[nextIndex];
            context = this.createContext(registry, nextHandlers, nextIndex + 1, exhausted);
        }
        this.requestConstants.applicationConstants.contextStorage.set(context);
        try {
            handler.handle(context);
        }
        catch (Exception e) {
            if (e instanceof HandlerException) {
                throw (HandlerException)e;
            }
            throw new HandlerException(context, e);
        }
    }

    private DefaultContext createContext(Registry registry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        return new DefaultContext(this.requestConstants, registry, nextHandlers, nextIndex, exhausted);
    }

    private class RejoinHandler
    implements Handler {
        private RejoinHandler() {
        }

        @Override
        public void handle(Context context) throws Exception {
            DefaultContext.this.doNext(DefaultContext.this, DefaultContext.this.registry, DefaultContext.this.nextIndex, DefaultContext.this.nextHandlers, DefaultContext.this.exhausted);
        }
    }

    public static class RequestConstants {
        private final ApplicationConstants applicationConstants;
        private final BindAddress bindAddress;
        private final Request request;
        private final Response response;
        private final DirectChannelAccess directChannelAccess;
        private final EventRegistry<RequestOutcome> onCloseRegistry;

        public RequestConstants(ApplicationConstants applicationConstants, BindAddress bindAddress, Request request, Response response, DirectChannelAccess directChannelAccess, EventRegistry<RequestOutcome> onCloseRegistry) {
            this.applicationConstants = applicationConstants;
            this.bindAddress = bindAddress;
            this.request = request;
            this.response = response;
            this.directChannelAccess = directChannelAccess;
            this.onCloseRegistry = onCloseRegistry;
        }
    }

    public static class ApplicationConstants {
        private final Foreground foreground;
        private final Background background;
        private final ContextStorage contextStorage;
        private final RenderController renderController;

        public ApplicationConstants(Foreground foreground, Background background, ContextStorage contextStorage, RenderController renderController) {
            this.foreground = foreground;
            this.contextStorage = contextStorage;
            this.renderController = renderController;
            this.background = background;
        }
    }
}

