/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.List;
import ratpack.handling.Context;
import ratpack.handling.ProcessingInterceptor;
import ratpack.util.ExceptionUtils;

public abstract class InterceptedOperation {
    private final ProcessingInterceptor.Type type;
    private final List<ProcessingInterceptor> interceptors;
    private final Context context;
    private Throwable thrown;
    private int i;

    public InterceptedOperation(ProcessingInterceptor.Type type, List<ProcessingInterceptor> interceptors, Context context) {
        this.type = type;
        this.interceptors = interceptors;
        this.context = context;
        this.i = interceptors.size() - 1;
    }

    public void run() {
        if (this.interceptors.isEmpty()) {
            this.performOperation();
        } else {
            this.nextInterceptor();
            if (this.thrown != null) {
                throw ExceptionUtils.uncheck(this.thrown);
            }
        }
    }

    private void nextInterceptor() {
        block6: {
            if (this.i >= 0) {
                int iAtStart = this.i;
                ProcessingInterceptor interceptor = this.interceptors.get(this.i);
                Runnable continuation = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InterceptedOperation.this.i -= 1;
                            InterceptedOperation.this.nextInterceptor();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                try {
                    interceptor.intercept(this.type, this.context, continuation);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (this.i == iAtStart) {
                        continuation.run();
                    }
                    break block6;
                }
            }
            try {
                this.performOperation();
            }
            catch (Throwable e) {
                this.thrown = e;
            }
        }
    }

    protected abstract void performOperation();
}

