/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.base.Throwables;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import ratpack.func.Transformer;
import ratpack.launch.LaunchConfig;
import ratpack.launch.LaunchException;
import ratpack.launch.internal.LaunchConfigInternal;
import ratpack.server.RatpackServer;
import ratpack.server.Stopper;
import ratpack.server.internal.InetSocketAddressBackedBindAddress;
import ratpack.util.ExceptionUtils;

public class NettyRatpackServer
implements RatpackServer {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final LaunchConfigInternal launchConfig;
    private final Transformer<Stopper, ChannelInitializer<SocketChannel>> channelInitializerTransformer;
    private InetSocketAddress boundAddress;
    private Channel channel;
    private EventLoopGroup group;
    private final Lock lifecycleLock = new ReentrantLock();
    private final AtomicBoolean running = new AtomicBoolean();

    public NettyRatpackServer(LaunchConfigInternal launchConfig, Transformer<Stopper, ChannelInitializer<SocketChannel>> channelInitializerTransformer) {
        this.launchConfig = launchConfig;
        this.channelInitializerTransformer = channelInitializerTransformer;
    }

    @Override
    public LaunchConfig getLaunchConfig() {
        return this.launchConfig;
    }

    @Override
    public void start() throws LaunchException {
        this.lifecycleLock.lock();
        try {
            if (this.isRunning()) {
                return;
            }
            Stopper stopper = new Stopper(){

                @Override
                public void stop() {
                    try {
                        NettyRatpackServer.this.stop();
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.uncheck(e);
                    }
                }
            };
            ServerBootstrap bootstrap = new ServerBootstrap();
            this.group = this.launchConfig.getEventLoopGroup();
            ChannelInitializer<SocketChannel> channelInitializer = this.channelInitializerTransformer.transform(stopper);
            ((ServerBootstrap)bootstrap.group(this.group).childHandler(channelInitializer).channel(NioServerSocketChannel.class)).childOption(ChannelOption.ALLOCATOR, (Object)this.launchConfig.getBufferAllocator());
            if (System.getProperty("io.netty.leakDetectionLevel", null) == null) {
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
            }
            this.channel = bootstrap.bind((SocketAddress)this.buildSocketAddress()).sync().channel();
            this.boundAddress = (InetSocketAddress)this.channel.localAddress();
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.info(String.format("Ratpack started for http://%s:%s", this.getBindHost(), this.getBindPort()));
            }
            this.running.set(true);
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, LaunchException.class);
            throw new LaunchException("Unable to launch due to exception", e);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        this.lifecycleLock.lock();
        try {
            if (!this.isRunning()) {
                return;
            }
            this.channel.close();
            this.partialShutdown();
            this.running.set(false);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    private void partialShutdown() {
        this.group.shutdownGracefully();
        this.launchConfig.getBackgroundExecutorService().shutdown();
    }

    @Override
    public String getScheme() {
        return this.launchConfig.getSSLContext() == null ? "http" : "https";
    }

    @Override
    public int getBindPort() {
        return this.boundAddress == null ? -1 : this.boundAddress.getPort();
    }

    @Override
    public String getBindHost() {
        if (this.boundAddress == null) {
            return null;
        }
        return InetSocketAddressBackedBindAddress.determineHost(this.boundAddress);
    }

    private InetSocketAddress buildSocketAddress() {
        return this.launchConfig.getAddress() == null ? new InetSocketAddress(this.launchConfig.getPort()) : new InetSocketAddress(this.launchConfig.getAddress(), this.launchConfig.getPort());
    }
}

