/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ratpack.util.MultiValueMap;

public class ImmutableDelegatingMultiValueMap<K, V>
implements MultiValueMap<K, V> {
    private final Map<? extends K, ? extends List<? extends V>> delegate;

    public ImmutableDelegatingMultiValueMap(Map<? extends K, ? extends List<? extends V>> map) {
        this.delegate = map;
    }

    @Override
    public List<V> getAll(K key) {
        return this.delegate.get(key);
    }

    @Override
    public Map<K, List<V>> getAll() {
        return this.delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (List<V> values : this.delegate.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        List<V> result = this.delegate.get(key);
        return result != null && result.size() > 0 ? (V)result.get(0) : null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.delegate.values()));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, List<V>> entry : this.delegate.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            result.add(new AbstractMap.SimpleImmutableEntry<K, V>(entry.getKey(), entry.getValue().get(0)));
        }
        return result;
    }

    public String toString() {
        if (this.delegate.isEmpty()) {
            return "[:]";
        }
        StringBuilder buffer = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry<K, List<V>> entry : this.delegate.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(entry.getKey().toString());
            buffer.append(":[");
            boolean firstValue = true;
            for (V value : entry.getValue()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(value.toString());
            }
            buffer.append("]");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

