/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecContext;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.ExecException;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Fulfiller;
import ratpack.exec.NoBoundContextException;
import ratpack.exec.Promise;
import ratpack.exec.internal.DefaultSuccessOrErrorPromise;
import ratpack.func.Action;
import ratpack.handling.internal.InterceptedOperation;

public class DefaultExecController
implements ExecController {
    private static final ThreadLocal<ExecController> THREAD_BINDING = new ThreadLocal();
    private final ThreadLocal<ExecContext.Supplier> contextSupplierThreadLocal = new ThreadLocal();
    private final ThreadLocal<List<Runnable>> onExecFinish = new ThreadLocal<List<Runnable>>(){

        @Override
        protected List<Runnable> initialValue() {
            return new LinkedList<Runnable>();
        }
    };
    private final ListeningScheduledExecutorService computeExecutor;
    private final ListeningExecutorService blockingExecutor;
    private final EventLoopGroup eventLoopGroup;
    private final ExecControl control;

    public DefaultExecController(int numThreads) {
        this.eventLoopGroup = new NioEventLoopGroup(numThreads, (ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-compute", 10)));
        this.computeExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)this.eventLoopGroup);
        this.blockingExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool((ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-blocking", 5))));
        this.control = new Control();
    }

    public static ExecController getThreadBoundController() {
        return THREAD_BINDING.get();
    }

    public static ExecContext getThreadBoundContext() {
        return DefaultExecController.getThreadBoundController().getContext();
    }

    @Override
    public void shutdown() throws Exception {
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.blockingExecutor.shutdown();
    }

    @Override
    public ExecContext getContext() throws NoBoundContextException {
        ExecContext.Supplier contextSupplier = this.contextSupplierThreadLocal.get();
        if (contextSupplier == null) {
            throw new NoBoundContextException("No context is bound to the current thread (are you calling this from a blocking operation?)");
        }
        return contextSupplier.get();
    }

    @Override
    public ListeningScheduledExecutorService getExecutor() {
        return this.computeExecutor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public void exec(ExecContext.Supplier execContextSupplier, Action<? super ExecContext> action) {
        this.exec(execContextSupplier, ExecInterceptor.ExecType.COMPUTE, action);
    }

    private void exec(final ExecContext.Supplier execContextSupplier, final ExecInterceptor.ExecType execType, final Action<? super ExecContext> action) {
        if (this.isManagedThread()) {
            this.doExec(execContextSupplier, execType, action);
        } else {
            this.eventLoopGroup.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultExecController.this.doExec(execContextSupplier, execType, action);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExec(ExecContext.Supplier execContextSupplier, ExecInterceptor.ExecType execType, final Action<? super ExecContext> action) {
        try {
            this.contextSupplierThreadLocal.set(execContextSupplier);
            new InterceptedOperation(execType, this.getContext().getInterceptors()){

                @Override
                protected void performOperation() throws Exception {
                    action.execute(DefaultExecController.this.getContext());
                }
            }.run();
        }
        catch (Throwable e) {
            this.onExecFinish.get().clear();
            ExecException.wrapAndForward(this.getContext(), e);
        }
        finally {
            this.contextSupplierThreadLocal.remove();
        }
        List<Runnable> runnables = this.onExecFinish.get();
        while (!runnables.isEmpty()) {
            runnables.remove(0).run();
        }
    }

    @Override
    public ExecControl getControl() {
        return this.control;
    }

    @Override
    public void onExecFinish(Runnable runnable) {
        this.onExecFinish.get().add(runnable);
    }

    @Override
    public boolean isManagedThread() {
        ExecController threadBoundController = DefaultExecController.getThreadBoundController();
        return threadBoundController != null && threadBoundController == this;
    }

    private class ExecControllerBindingThreadFactory
    extends DefaultThreadFactory {
        public ExecControllerBindingThreadFactory(String name, int priority) {
            super(name, priority);
        }

        public Thread newThread(final Runnable r) {
            return super.newThread(new Runnable(){

                @Override
                public void run() {
                    THREAD_BINDING.set(DefaultExecController.this);
                    r.run();
                }
            });
        }
    }

    private class Control
    implements ExecControl {
        private Control() {
        }

        @Override
        public <T> Promise<T> blocking(final Callable<T> operation) {
            final ExecContext context = DefaultExecController.this.getContext();
            return context.promise(new Action<Fulfiller<? super T>>(){

                @Override
                public void execute(Fulfiller<? super T> fulfiller) throws Exception {
                    ListenableFuture future = DefaultExecController.this.blockingExecutor.submit((Callable)new BlockingOperation());
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new ComputeResume(fulfiller), (Executor)DefaultExecController.this.computeExecutor);
                }

                class ComputeResume
                implements FutureCallback<T> {
                    private final Fulfiller<? super T> fulfiller;

                    public ComputeResume(Fulfiller<? super T> fulfiller) {
                        this.fulfiller = fulfiller;
                    }

                    public void onSuccess(T result) {
                        this.fulfiller.success(result);
                    }

                    public void onFailure(Throwable t) {
                        this.fulfiller.error(t);
                    }
                }

                class BlockingOperation
                implements Callable<T> {
                    private Exception exception;
                    private T result;

                    BlockingOperation() {
                    }

                    @Override
                    public T call() throws Exception {
                        DefaultExecController.this.exec(context.getSupplier(), ExecInterceptor.ExecType.BLOCKING, new Action<ExecContext>(){

                            @Override
                            public void execute(ExecContext thing) throws Exception {
                                try {
                                    BlockingOperation.this.result = operation.call();
                                }
                                catch (Exception e) {
                                    BlockingOperation.this.exception = e;
                                }
                            }
                        });
                        if (this.exception != null) {
                            throw this.exception;
                        }
                        return this.result;
                    }
                }
            });
        }

        @Override
        public <T> Promise<T> promise(Action<? super Fulfiller<T>> action) {
            return new DefaultSuccessOrErrorPromise(DefaultExecController.this.getContext(), DefaultExecController.this, action);
        }
    }
}

