/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import ratpack.exec.ExecContext;
import ratpack.exec.ExecController;
import ratpack.exec.Fulfiller;
import ratpack.exec.SuccessPromise;
import ratpack.func.Action;

public class DefaultSuccessPromise<T>
implements SuccessPromise<T> {
    private final ExecContext context;
    private final ExecController execController;
    private final Action<? super Fulfiller<T>> action;
    private final Action<? super Throwable> errorHandler;

    public DefaultSuccessPromise(ExecContext context, ExecController execController, Action<? super Fulfiller<T>> action, Action<? super Throwable> errorHandler) {
        this.context = context;
        this.execController = execController;
        this.action = action;
        this.errorHandler = errorHandler;
    }

    @Override
    public void then(final Action<? super T> then) {
        this.execController.onExecFinish(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultSuccessPromise.this.action.execute(new Fulfiller<T>(){

                        @Override
                        public void error(final Throwable throwable) {
                            DefaultSuccessPromise.this.execController.exec(DefaultSuccessPromise.this.context.getSupplier(), (Action<? super ExecContext>)new Action<ExecContext>(){

                                @Override
                                public void execute(ExecContext context) throws Exception {
                                    DefaultSuccessPromise.this.errorHandler.execute(throwable);
                                }
                            });
                        }

                        @Override
                        public void success(final T value) {
                            DefaultSuccessPromise.this.execController.exec(DefaultSuccessPromise.this.context.getSupplier(), (Action<? super ExecContext>)new Action<ExecContext>(){

                                @Override
                                public void execute(ExecContext context) throws Exception {
                                    then.execute(value);
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    DefaultSuccessPromise.this.context.error(e);
                }
            }
        });
    }
}

