/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import ratpack.file.FileSystemBinding;
import ratpack.file.internal.DefaultFileSystemBinding;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;
import ratpack.launch.internal.DefaultLaunchConfig;

public class LaunchConfigBuilder {
    private FileSystemBinding baseDir;
    private int port = 5050;
    private InetAddress address;
    private boolean reloadable;
    private int mainThreads;
    private URI publicAddress;
    private ImmutableList.Builder<String> indexFiles = ImmutableList.builder();
    private ImmutableMap.Builder<String, String> other = ImmutableMap.builder();
    private ByteBufAllocator byteBufAllocator = PooledByteBufAllocator.DEFAULT;
    private SSLContext sslContext;
    private int maxContentLength = 65536;
    private boolean timeResponses;
    private boolean compressResponses;

    private LaunchConfigBuilder() {
    }

    private LaunchConfigBuilder(Path baseDir) {
        this.baseDir = new DefaultFileSystemBinding(baseDir);
    }

    public static LaunchConfigBuilder noBaseDir() {
        return new LaunchConfigBuilder();
    }

    public static LaunchConfigBuilder baseDir(File baseDir) {
        return LaunchConfigBuilder.baseDir(baseDir.toPath());
    }

    public static LaunchConfigBuilder baseDir(Path baseDir) {
        return new LaunchConfigBuilder(baseDir.toAbsolutePath().normalize());
    }

    public LaunchConfigBuilder port(int port) {
        this.port = port;
        return this;
    }

    public LaunchConfigBuilder address(InetAddress address) {
        this.address = address;
        return this;
    }

    public LaunchConfigBuilder reloadable(boolean reloadable) {
        this.reloadable = reloadable;
        return this;
    }

    public LaunchConfigBuilder threads(int threads) {
        this.mainThreads = threads;
        return this;
    }

    public LaunchConfigBuilder bufferAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
        return this;
    }

    public LaunchConfigBuilder publicAddress(URI publicAddress) {
        this.publicAddress = publicAddress;
        return this;
    }

    public LaunchConfigBuilder maxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public LaunchConfigBuilder timeResponses(boolean timeResponses) {
        this.timeResponses = timeResponses;
        return this;
    }

    public LaunchConfigBuilder compressResponses(boolean compressResponses) {
        this.compressResponses = compressResponses;
        return this;
    }

    public LaunchConfigBuilder indexFiles(String ... indexFiles) {
        this.indexFiles.add((Object[])indexFiles);
        return this;
    }

    public LaunchConfigBuilder indexFiles(List<String> indexFiles) {
        this.indexFiles.addAll(indexFiles);
        return this;
    }

    public LaunchConfigBuilder ssl(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public LaunchConfigBuilder other(String key, String value) {
        this.other.put((Object)key, (Object)value);
        return this;
    }

    public LaunchConfigBuilder other(Map<String, String> other) {
        for (Map.Entry<String, String> entry : other.entrySet()) {
            this.other(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public LaunchConfig build(HandlerFactory handlerFactory) {
        return new DefaultLaunchConfig(this.baseDir, this.port, this.address, this.reloadable, this.mainThreads, this.byteBufAllocator, this.publicAddress, (ImmutableList<String>)this.indexFiles.build(), (ImmutableMap<String, String>)this.other.build(), this.sslContext, this.maxContentLength, this.timeResponses, this.compressResponses, handlerFactory);
    }

    public LaunchConfig build() {
        return this.build(null);
    }
}

