/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ratpack.path.PathBinder;
import ratpack.path.PathBinding;
import ratpack.path.internal.DefaultPathBinding;

public class TokenPathBinder
implements PathBinder {
    private final ImmutableList<String> tokenNames;
    private final Pattern regex;

    public TokenPathBinder(String path, boolean exact) {
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        String pattern = Pattern.quote(path);
        Pattern placeholderPattern = Pattern.compile("((?:^|/):(\\w+)\\??)");
        Matcher matchResult = placeholderPattern.matcher(path);
        String replacementStart = "\\\\E(?:(?:^|/)([^/?&#]+))";
        StringBuilder replacementBuilder = new StringBuilder(replacementStart);
        boolean hasOptional = false;
        while (matchResult.find()) {
            String part = matchResult.group(1);
            String name = matchResult.group(2);
            boolean optional = part.endsWith("?");
            if (!hasOptional && optional) {
                int contentQuantifierIndex = replacementStart.indexOf("+");
                replacementBuilder.replace(contentQuantifierIndex, contentQuantifierIndex + 1, "*");
            }
            boolean bl = hasOptional = hasOptional || optional;
            if (hasOptional && !optional) {
                throw new IllegalArgumentException(String.format("path %s should not define mandatory parameters after an optional parameter", path));
            }
            if (optional) {
                replacementBuilder.append("?");
            }
            replacementBuilder.append("\\\\Q");
            pattern = pattern.replaceFirst(Pattern.quote(part), replacementBuilder.toString());
            namesBuilder.add((Object)name);
            replacementBuilder.delete(replacementStart.length(), replacementBuilder.length());
        }
        StringBuilder patternBuilder = new StringBuilder("(").append(pattern).append(")");
        if (exact) {
            patternBuilder.append("(?:/|$)");
        } else {
            patternBuilder.append("(?:/.*)?");
        }
        this.regex = Pattern.compile(patternBuilder.toString());
        this.tokenNames = namesBuilder.build();
    }

    @Override
    public PathBinding bind(String path, PathBinding parentBinding) {
        Matcher matcher;
        if (parentBinding != null) {
            path = parentBinding.getPastBinding();
        }
        if ((matcher = this.regex.matcher(path)).matches()) {
            MatchResult matchResult = matcher.toMatchResult();
            String boundPath = matchResult.group(1);
            ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
            int i = 2;
            for (String name : this.tokenNames) {
                String value;
                if ((value = matchResult.group(i++)) == null) continue;
                paramsBuilder.put((Object)name, (Object)this.decodeURIComponent(value));
            }
            return new DefaultPathBinding(path, boundPath, (ImmutableMap<String, String>)paramsBuilder.build(), parentBinding);
        }
        return null;
    }

    private String decodeURIComponent(String s) {
        String str = null;
        try {
            str = URLDecoder.decode(s.replaceAll("\\+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new IllegalStateException("UTF-8 decoder should always be available");
        }
        return str;
    }
}

