/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;

public class HierarchicalRegistry
implements Registry {
    private final Registry parent;
    private final Registry child;

    public HierarchicalRegistry(Registry parent, Registry child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        O object = this.child.maybeGet(type);
        if (object == null) {
            object = this.parent.maybeGet(type);
        }
        return object;
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    @Override
    public <O> List<O> getAll(TypeToken<O> type) {
        List<O> childAll = this.child.getAll(type);
        List<O> parentAll = this.parent.getAll(type);
        return ImmutableList.builder().addAll(childAll).addAll(parentAll).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalRegistry that = (HierarchicalRegistry)o;
        return this.child.equals(that.child) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        int result = this.parent.hashCode();
        result = 31 * result + this.child.hashCode();
        return result;
    }
}

