/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;

public class MultiEntryRegistry<T>
implements Registry {
    private final List<RegistryEntry<? extends T>> entries;

    public MultiEntryRegistry(List<RegistryEntry<? extends T>> entries) {
        this.entries = entries;
    }

    public String toString() {
        return "Registry{" + this.entries + '}';
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        for (RegistryEntry<T> entry : this.entries) {
            if (!type.isAssignableFrom(entry.getType())) continue;
            T cast = entry.get();
            return (O)cast;
        }
        return null;
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    @Override
    public <O> List<O> getAll(TypeToken<O> type) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RegistryEntry<T> entry : this.entries) {
            if (!type.isAssignableFrom(entry.getType())) continue;
            T cast = entry.get();
            builder.add(cast);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiEntryRegistry that = (MultiEntryRegistry)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }
}

