/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.internal.RegistryEntry;

public class SingleEntryRegistry
implements Registry {
    private final RegistryEntry<?> entry;

    public SingleEntryRegistry(RegistryEntry<?> entry) {
        this.entry = entry;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.get(TypeToken.of(type));
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        O value = this.maybeGet(type);
        if (value == null) {
            throw new NotInRegistryException(type);
        }
        return value;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.maybeGet(TypeToken.of(type));
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        if (type.isAssignableFrom(this.entry.getType())) {
            Object cast = this.entry.get();
            return (O)cast;
        }
        return null;
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        return this.getAll(TypeToken.of(type));
    }

    @Override
    public <O> List<O> getAll(TypeToken<O> type) {
        O value = this.maybeGet(type);
        if (value == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleEntryRegistry that = (SingleEntryRegistry)o;
        return this.entry.equals(that.entry);
    }

    public int hashCode() {
        return this.entry.hashCode();
    }
}

