/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.ExecutionException;
import ratpack.exec.ExecutionSegmentTerminationError;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.exec.internal.DefaultPromise;
import ratpack.func.Action;
import ratpack.handling.internal.InterceptedOperation;
import ratpack.registry.internal.SimpleMutableRegistry;
import ratpack.util.ExceptionUtils;

public class DefaultExecController
implements ExecController {
    private static final ThreadLocal<ExecController> THREAD_BINDING = new ThreadLocal();
    private final ThreadLocal<Execution> executionHolder = new ThreadLocal();
    private final ListeningScheduledExecutorService computeExecutor;
    private final ListeningExecutorService blockingExecutor;
    private final EventLoopGroup eventLoopGroup;
    private final ExecControl control;

    public DefaultExecController(int numThreads) {
        this.eventLoopGroup = new NioEventLoopGroup(numThreads, (ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-compute", 10)));
        this.computeExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)this.eventLoopGroup);
        this.blockingExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool((ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-blocking", 5))));
        this.control = new Control();
    }

    public static Optional<ExecController> getThreadBoundController() {
        return Optional.fromNullable((Object)THREAD_BINDING.get());
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.blockingExecutor.shutdown();
    }

    @Override
    public Execution getExecution() throws ExecutionException {
        Execution execution = this.executionHolder.get();
        if (execution == null) {
            throw new ExecutionException("No execution is bound to the current thread (are you calling this from a blocking operation or a manual created thread?)");
        }
        return execution;
    }

    @Override
    public ListeningScheduledExecutorService getExecutor() {
        return this.computeExecutor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public void start(final Action<? super ratpack.exec.Execution> action) {
        if (!this.isManagedThread() || this.executionHolder.get() != null) {
            this.computeExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    DefaultExecController.this.start(action);
                }
            });
        } else {
            new Execution(action);
        }
    }

    @Override
    public ExecControl getControl() {
        return this.control;
    }

    @Override
    public boolean isManagedThread() {
        Optional<ExecController> threadBoundController = DefaultExecController.getThreadBoundController();
        return threadBoundController.isPresent() && threadBoundController.get() == this;
    }

    private class ExecControllerBindingThreadFactory
    extends DefaultThreadFactory {
        public ExecControllerBindingThreadFactory(String name, int priority) {
            super(name, priority);
        }

        public Thread newThread(final Runnable r) {
            return super.newThread(new Runnable(){

                @Override
                public void run() {
                    THREAD_BINDING.set(DefaultExecController.this);
                    r.run();
                }
            });
        }
    }

    private class Control
    implements ExecControl {
        private Control() {
        }

        @Override
        public <T> Promise<T> blocking(final Callable<T> operation) {
            final Execution execution = DefaultExecController.this.getExecution();
            return this.promise(new Action<Fulfiller<? super T>>(){

                @Override
                public void execute(Fulfiller<? super T> fulfiller) throws Exception {
                    ListenableFuture future = DefaultExecController.this.blockingExecutor.submit((Callable)new BlockingOperation());
                    Futures.addCallback((ListenableFuture)future, (FutureCallback)new ComputeResume(fulfiller), (Executor)DefaultExecController.this.computeExecutor);
                }

                class ComputeResume
                implements FutureCallback<T> {
                    private final Fulfiller<? super T> fulfiller;

                    public ComputeResume(Fulfiller<? super T> fulfiller) {
                        this.fulfiller = fulfiller;
                    }

                    public void onSuccess(T result) {
                        this.fulfiller.success(result);
                    }

                    public void onFailure(Throwable t) {
                        this.fulfiller.error(t);
                    }
                }

                class BlockingOperation
                implements Callable<T> {
                    private Exception exception;
                    private T result;

                    BlockingOperation() {
                    }

                    @Override
                    public T call() throws Exception {
                        execution.intercept(ExecInterceptor.ExecType.BLOCKING, execution.interceptors, (Action<? super Execution>)new Action<Execution>(){

                            @Override
                            public void execute(Execution execution) throws Exception {
                                try {
                                    BlockingOperation.this.result = operation.call();
                                }
                                catch (Exception e) {
                                    BlockingOperation.this.exception = e;
                                }
                            }
                        });
                        if (this.exception != null) {
                            throw this.exception;
                        }
                        return this.result;
                    }
                }
            });
        }

        @Override
        public <T> Promise<T> promise(Action<? super Fulfiller<T>> action) {
            return new DefaultPromise(DefaultExecController.this.getExecution(), action);
        }
    }

    public class Execution
    extends SimpleMutableRegistry
    implements ratpack.exec.Execution {
        private final List<ExecInterceptor> interceptors = new LinkedList<ExecInterceptor>();
        private final Deque<Runnable> segments = new ConcurrentLinkedDeque<Runnable>();
        private final Queue<Runnable> onCompletes = new ConcurrentLinkedQueue<Runnable>();
        private Action<? super Throwable> errorHandler = new Action<Throwable>(){

            @Override
            public void execute(Throwable throwable) throws Exception {
                throw ExceptionUtils.toException(throwable);
            }
        };
        private final AtomicBoolean active = new AtomicBoolean();
        private boolean waiting;
        private boolean done;

        public Execution(Action<? super ratpack.exec.Execution> action) {
            this.segments.addLast(new UserCodeSegment(action));
            this.tryDrain();
        }

        @Override
        public <T> Promise<T> blocking(Callable<T> blockingOperation) {
            return DefaultExecController.this.control.blocking(blockingOperation);
        }

        @Override
        public <T> Promise<T> promise(Action<? super Fulfiller<T>> action) {
            return DefaultExecController.this.control.promise(action);
        }

        @Override
        public void setErrorHandler(Action<? super Throwable> errorHandler) {
            this.errorHandler = errorHandler;
        }

        @Override
        public void addInterceptor(ExecInterceptor execInterceptor, Action<? super ratpack.exec.Execution> continuation) throws Exception {
            this.interceptors.add(execInterceptor);
            this.intercept(ExecInterceptor.ExecType.COMPUTE, Collections.singletonList(execInterceptor), continuation);
        }

        @Override
        public ExecController getController() {
            return DefaultExecController.this;
        }

        public void join(Action<? super ratpack.exec.Execution> action) {
            this.segments.addFirst(new UserCodeSegment(action));
            this.waiting = false;
            this.tryDrain();
        }

        public void continueVia(final Runnable runnable) {
            this.segments.addFirst(new Runnable(){

                @Override
                public void run() {
                    Execution.this.waiting = true;
                    runnable.run();
                }
            });
        }

        private void tryDrain() {
            if (!this.done && !this.waiting && !this.segments.isEmpty() && this.active.compareAndSet(false, true)) {
                this.drain();
                if (this.done) {
                    this.runOnCompletes();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runOnCompletes() {
            Runnable onComplete = this.onCompletes.poll();
            while (onComplete != null) {
                try {
                    onComplete.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    onComplete = this.onCompletes.poll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drain() {
            if (DefaultExecController.this.isManagedThread()) {
                DefaultExecController.this.executionHolder.set(this);
                try {
                    Runnable segment = this.segments.poll();
                    while (segment != null) {
                        segment.run();
                        if (this.done) {
                            return;
                        }
                        segment = this.waiting ? null : this.segments.poll();
                    }
                }
                finally {
                    DefaultExecController.this.executionHolder.remove();
                    this.active.set(false);
                }
                this.tryDrain();
            } else {
                this.active.set(false);
                DefaultExecController.this.eventLoopGroup.submit(new Runnable(){

                    @Override
                    public void run() {
                        Execution.this.tryDrain();
                    }
                });
            }
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void onComplete(Runnable runnable) {
            this.onCompletes.add(runnable);
        }

        public void intercept(ExecInterceptor.ExecType execType, List<ExecInterceptor> interceptors, final Action<? super Execution> action) throws Exception {
            new InterceptedOperation(execType, interceptors){

                @Override
                protected void performOperation() throws Exception {
                    action.execute(Execution.this);
                }
            }.run();
        }

        private class UserCodeSegment
        implements Runnable {
            private final Action<? super ratpack.exec.Execution> action;

            public UserCodeSegment(Action<? super ratpack.exec.Execution> action) {
                this.action = action;
            }

            @Override
            public void run() {
                try {
                    try {
                        Execution.this.intercept(ExecInterceptor.ExecType.COMPUTE, Execution.this.interceptors, this.action);
                    }
                    catch (ExecutionSegmentTerminationError e) {
                        throw e.getCause();
                    }
                }
                catch (Throwable e) {
                    Execution.this.segments.clear();
                    Execution.this.segments.addFirst(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Execution.this.errorHandler.execute(e);
                            }
                            catch (Throwable e2) {
                                Execution.this.segments.addFirst(new UserCodeSegment((Action<? super ratpack.exec.Execution>)new Action<ratpack.exec.Execution>(){

                                    @Override
                                    public void execute(ratpack.exec.Execution execution) throws Exception {
                                        throw e2;
                                    }
                                }));
                            }
                        }
                    });
                }
            }
        }
    }
}

