/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.OverlappingExecutionException;
import ratpack.exec.SuccessPromise;
import ratpack.exec.internal.DefaultExecController;
import ratpack.func.Action;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.InternalRatpackError;

public class DefaultSuccessPromise<T>
implements SuccessPromise<T> {
    private final DefaultExecController.Execution execution;
    private final Action<? super Fulfiller<T>> action;
    private final Action<? super Throwable> errorHandler;

    public DefaultSuccessPromise(DefaultExecController.Execution execution, Action<? super Fulfiller<T>> action, Action<? super Throwable> errorHandler) {
        this.execution = execution;
        this.action = action;
        this.errorHandler = errorHandler;
    }

    @Override
    public void then(final Action<? super T> then) {
        try {
            this.execution.continueVia(new Runnable(){
                private final AtomicBoolean fulfilled = new AtomicBoolean();

                @Override
                public void run() {
                    try {
                        DefaultSuccessPromise.this.action.execute(new Fulfiller<T>(){

                            @Override
                            public void error(final Throwable throwable) {
                                if (!fulfilled.compareAndSet(false, true)) {
                                    new OverlappingExecutionException("promise already fulfilled").printStackTrace();
                                    return;
                                }
                                DefaultSuccessPromise.this.execution.join((Action<? super Execution>)new Action<Execution>(){

                                    @Override
                                    public void execute(Execution execution) throws Exception {
                                        DefaultSuccessPromise.this.errorHandler.execute(throwable);
                                    }
                                });
                            }

                            @Override
                            public void success(final T value) {
                                if (!fulfilled.compareAndSet(false, true)) {
                                    new OverlappingExecutionException("promise already fulfilled").printStackTrace();
                                    return;
                                }
                                DefaultSuccessPromise.this.execution.join((Action<? super Execution>)new Action<Execution>(){

                                    @Override
                                    public void execute(Execution execution) throws Exception {
                                        then.execute(value);
                                    }
                                });
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!this.fulfilled.compareAndSet(false, true)) {
                            new OverlappingExecutionException("exception thrown after promise was fulfilled", e).printStackTrace();
                        }
                        DefaultSuccessPromise.this.execution.join((Action<? super Execution>)new Action<Execution>(){

                            @Override
                            public void execute(Execution execution) throws Exception {
                                throw ExceptionUtils.toException(e);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InternalRatpackError("failed to add promise resume action");
        }
    }
}

