/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.internal.Extractions;
import ratpack.registry.Registries;
import ratpack.util.ExceptionUtils;

public abstract class InjectionHandler
implements Handler {
    private final List<TypeToken<?>> types;
    private final Method handleMethod;

    protected InjectionHandler() throws NoSuitableHandleMethodException {
        Class<?> thisClass = this.getClass();
        Method handleMethod = null;
        for (Method method : thisClass.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals("handle") || (parameterTypes = method.getParameterTypes()).length < 2 || !parameterTypes[0].equals(Context.class)) continue;
            handleMethod = method;
            break;
        }
        if (handleMethod == null) {
            throw new NoSuitableHandleMethodException((Class)thisClass);
        }
        try {
            handleMethod.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new NoSuitableHandleMethodException(thisClass, e);
        }
        this.handleMethod = handleMethod;
        Type[] parameterTypes = handleMethod.getGenericParameterTypes();
        this.types = new ArrayList(parameterTypes.length - 1);
        for (int i = 1; i < parameterTypes.length; ++i) {
            this.types.add(TypeToken.of((Type)parameterTypes[i]));
        }
    }

    @Override
    public final void handle(Context context) {
        Object[] args = new Object[this.types.size() + 1];
        args[0] = context;
        Extractions.extract(this.types, Registries.join(context.getRequest(), context), args, 1);
        try {
            this.handleMethod.invoke((Object)this, args);
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.uncheck(e);
        }
        catch (InvocationTargetException e) {
            Throwable root = e.getTargetException();
            throw ExceptionUtils.uncheck(root);
        }
    }

    public static class NoSuitableHandleMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private NoSuitableHandleMethodException(Class<?> clazz) {
            super("No injectable handle method found for " + clazz.getName());
        }

        public NoSuitableHandleMethodException(Class<?> clazz, SecurityException cause) {
            super("Unable to make handle method accessible for " + clazz.getName(), cause);
        }
    }
}

