/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.event.internal.EventRegistry;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.handling.ByContentHandler;
import ratpack.handling.ByMethodHandler;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Redirector;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.handling.internal.DefaultByContentHandler;
import ratpack.handling.internal.DefaultByMethodHandler;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.launch.LaunchConfig;
import ratpack.parse.NoSuchParserException;
import ratpack.parse.Parse;
import ratpack.parse.Parser;
import ratpack.parse.ParserException;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.render.NoSuchRendererException;
import ratpack.render.internal.RenderController;
import ratpack.server.BindAddress;
import ratpack.util.ExceptionUtils;

public class DefaultContext
implements Context {
    private static final TypeToken<Parser<?>> PARSER_TYPE_TOKEN = new TypeToken<Parser<?>>(){
        private static final long serialVersionUID = 0L;
    };
    private static final Logger LOGGER = Logger.getLogger(Context.class.getName());
    private final RequestConstants requestConstants;
    private final Registry registry;
    private final Handler[] nextHandlers;
    private final int nextIndex;
    private final Handler exhausted;

    public DefaultContext(RequestConstants requestConstants, Registry registry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        this.requestConstants = requestConstants;
        this.registry = registry;
        this.nextHandlers = nextHandlers;
        this.nextIndex = nextIndex;
        this.exhausted = exhausted;
        this.requestConstants.context = this;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public Execution getExecution() {
        return this.requestConstants.execution;
    }

    @Override
    public <T> Promise<T> blocking(Callable<T> blockingOperation) {
        return this.requestConstants.applicationConstants.execControl.blocking(blockingOperation);
    }

    @Override
    public <T> Promise<T> promise(Action<? super Fulfiller<T>> action) {
        return this.requestConstants.applicationConstants.execControl.promise(action);
    }

    @Override
    public LaunchConfig getLaunchConfig() {
        return this.requestConstants.applicationConstants.launchConfig;
    }

    @Override
    public Request getRequest() {
        return this.requestConstants.request;
    }

    @Override
    public Response getResponse() {
        return this.requestConstants.response;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.registry.getAll(type);
    }

    @Override
    public void addExecInterceptor(ExecInterceptor execInterceptor, final Action<? super Context> action) throws Exception {
        this.requestConstants.execution.addInterceptor(execInterceptor, (Action<? super Execution>)new Action<Execution>(){

            @Override
            public void execute(Execution execution) throws Exception {
                action.execute(DefaultContext.this);
            }
        });
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public void next() {
        this.doNext(this, this.registry, this.nextIndex, this.nextHandlers, this.exhausted);
    }

    @Override
    public void next(Registry registry) {
        Registry joinedRegistry = Registries.join(this.registry, registry);
        this.doNext(this, joinedRegistry, this.nextIndex, this.nextHandlers, new RejoinHandler());
    }

    @Override
    public void insert(Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.doNext(this, this.registry, 0, handlers, new RejoinHandler());
    }

    @Override
    public void insert(Registry registry, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        Registry joinedRegistry = Registries.join(this.registry, registry);
        this.doNext(this, joinedRegistry, 0, handlers, new RejoinHandler());
    }

    @Override
    public void respond(Handler handler) {
        try {
            handler.handle(this);
        }
        catch (Throwable e) {
            this.error(ExceptionUtils.toException(e));
        }
    }

    @Override
    public PathTokens getPathTokens() {
        return this.get(PathBinding.class).getTokens();
    }

    @Override
    public PathTokens getAllPathTokens() {
        return this.get(PathBinding.class).getAllTokens();
    }

    @Override
    public Path file(String path) {
        return this.get(FileSystemBinding.class).file(path);
    }

    @Override
    public void render(Object object) throws NoSuchRendererException {
        try {
            this.requestConstants.applicationConstants.renderController.render(object, this);
        }
        catch (NoSuchRendererException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public <T, O> T parse(Parse<T, O> parse) throws ParserException, NoSuchParserException {
        Parser<?> parser;
        String requestContentType = this.requestConstants.request.getBody().getContentType().getType();
        if (requestContentType == null) {
            requestContentType = "text/plain";
        }
        if ((parser = this.registry.first(PARSER_TYPE_TOKEN, new ParserForParsePredicate(parse, requestContentType))) != null) {
            Parser<?> castParser = parser;
            try {
                return castParser.parse(this, this.getRequest().getBody(), parse);
            }
            catch (Exception e) {
                throw new ParserException(parser, (Throwable)e);
            }
        }
        throw new NoSuchParserException(parse.getType(), parse.getOpts(), requestContentType);
    }

    @Override
    public <T> T parse(Class<T> type) throws NoSuchParserException, ParserException {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T> T parse(TypeToken<T> type) throws NoSuchParserException, ParserException {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T, O> T parse(Class<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public <T, O> T parse(TypeToken<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public void onClose(Action<? super RequestOutcome> callback) {
        this.requestConstants.onCloseRegistry.register(callback);
    }

    @Override
    public DirectChannelAccess getDirectChannelAccess() {
        return this.requestConstants.directChannelAccess;
    }

    @Override
    public void redirect(String location) {
        this.redirect(HttpResponseStatus.FOUND.code(), location);
    }

    @Override
    public void redirect(int code, String location) {
        Redirector redirector = this.registry.get(Redirector.class);
        redirector.redirect(this, location, code);
    }

    @Override
    public void lastModified(Date date, Runnable runnable) {
        long time;
        long ifModifiedSinceSecs;
        Date ifModifiedSinceHeader = this.requestConstants.request.getHeaders().getDate("If-Modified-Since");
        long lastModifiedSecs = date.getTime() / 1000L;
        if (ifModifiedSinceHeader != null && lastModifiedSecs == (ifModifiedSinceSecs = (time = ifModifiedSinceHeader.getTime()) / 1000L)) {
            this.requestConstants.response.status(HttpResponseStatus.NOT_MODIFIED.code(), HttpResponseStatus.NOT_MODIFIED.reasonPhrase()).send();
            return;
        }
        this.requestConstants.response.getHeaders().setDate(HttpHeaderConstants.LAST_MODIFIED, date);
        runnable.run();
    }

    @Override
    public BindAddress getBindAddress() {
        return this.requestConstants.bindAddress;
    }

    @Override
    public void error(Exception exception) {
        ServerErrorHandler serverErrorHandler = this.get(ServerErrorHandler.class);
        Exception unpacked = this.unpackException(exception);
        try {
            serverErrorHandler.error(this, unpacked);
        }
        catch (Exception errorHandlerException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            stringWriter.append("Exception thrown by error handler ").append(serverErrorHandler.toString()).append(" while handling exception\nOriginal exception: ");
            unpacked.printStackTrace(printWriter);
            stringWriter.append("Error handler exception: ");
            errorHandlerException.printStackTrace(printWriter);
            LOGGER.warning(stringWriter.toString());
            this.requestConstants.response.status(500).send();
        }
    }

    private Exception unpackException(Exception exception) {
        if (exception instanceof UndeclaredThrowableException) {
            return ExceptionUtils.toException(exception.getCause());
        }
        return exception;
    }

    @Override
    public void clientError(int statusCode) {
        try {
            this.get(ClientErrorHandler.class).error(this, statusCode);
        }
        catch (Throwable e) {
            this.error(ExceptionUtils.toException(e));
        }
    }

    @Override
    public ByMethodHandler getByMethod() {
        return new DefaultByMethodHandler();
    }

    @Override
    public ByContentHandler getByContent() {
        return new DefaultByContentHandler();
    }

    protected void doNext(Context parentContext, Registry registry, int nextIndex, Handler[] nextHandlers, Handler exhausted) {
        Handler handler;
        Context context;
        if (nextIndex >= nextHandlers.length) {
            context = parentContext;
            handler = exhausted;
        } else {
            handler = nextHandlers[nextIndex];
            context = this.createContext(registry, nextHandlers, nextIndex + 1, exhausted);
        }
        try {
            handler.handle(context);
        }
        catch (Throwable e) {
            if (e instanceof HandlerException) {
                throw (HandlerException)e;
            }
            throw new HandlerException(e);
        }
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <T> T first(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.first(type, predicate);
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.all(type, predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        return this.registry.each(type, predicate, action);
    }

    private DefaultContext createContext(Registry registry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        return new DefaultContext(this.requestConstants, registry, nextHandlers, nextIndex, exhausted);
    }

    private static class ParserForParsePredicate
    implements Predicate<Parser<?>> {
        private final Parse<?, ?> parse;
        private final String contentType;

        private ParserForParsePredicate(Parse<?, ?> parse, String contentType) {
            this.parse = parse;
            this.contentType = contentType;
        }

        public boolean apply(Parser<?> parser) {
            return this.contentType.equalsIgnoreCase(parser.getContentType()) && parser.getOptsType().isInstance(this.parse.getOpts());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParserForParsePredicate that = (ParserForParsePredicate)o;
            return this.contentType.equalsIgnoreCase(that.contentType) && this.parse.equals(that.parse);
        }

        public int hashCode() {
            int result = this.contentType.hashCode();
            result = 31 * result + this.parse.hashCode();
            return result;
        }
    }

    private class RejoinHandler
    implements Handler {
        private RejoinHandler() {
        }

        @Override
        public void handle(Context context) throws Exception {
            DefaultContext.this.doNext(DefaultContext.this, DefaultContext.this.registry, DefaultContext.this.nextIndex, DefaultContext.this.nextHandlers, DefaultContext.this.exhausted);
        }
    }

    private static class HandlerException
    extends Error {
        private static final long serialVersionUID = 0L;

        private HandlerException(Throwable cause) {
            super(cause);
        }
    }

    public static class RequestConstants {
        private final ApplicationConstants applicationConstants;
        private final BindAddress bindAddress;
        private final Request request;
        private final Response response;
        private final DirectChannelAccess directChannelAccess;
        private final EventRegistry<RequestOutcome> onCloseRegistry;
        public Execution execution;
        public Context context;

        public RequestConstants(ApplicationConstants applicationConstants, BindAddress bindAddress, Request request, Response response, DirectChannelAccess directChannelAccess, EventRegistry<RequestOutcome> onCloseRegistry, Execution execution) {
            this.applicationConstants = applicationConstants;
            this.bindAddress = bindAddress;
            this.request = request;
            this.response = response;
            this.directChannelAccess = directChannelAccess;
            this.onCloseRegistry = onCloseRegistry;
            this.execution = execution;
            this.execution.setErrorHandler((Action<? super Throwable>)new Action<Throwable>(){

                @Override
                public void execute(Throwable throwable) throws Exception {
                    RequestConstants.this.context.error(ExceptionUtils.toException(throwable instanceof HandlerException ? throwable.getCause() : throwable));
                }
            });
        }
    }

    public static class ApplicationConstants {
        private final RenderController renderController;
        private final LaunchConfig launchConfig;
        private final ExecControl execControl;

        public ApplicationConstants(LaunchConfig launchConfig, RenderController renderController) {
            this.renderController = renderController;
            this.launchConfig = launchConfig;
            this.execControl = launchConfig.getExecController().getControl();
        }
    }
}

