/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetAddress;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import ratpack.exec.ExecController;
import ratpack.exec.internal.DefaultExecController;
import ratpack.file.FileSystemBinding;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;
import ratpack.launch.NoBaseDirException;

public class DefaultLaunchConfig
implements LaunchConfig {
    private final FileSystemBinding baseDir;
    private final HandlerFactory handlerFactory;
    private final int port;
    private final InetAddress address;
    private final boolean reloadable;
    private final int threads;
    private final ExecController execController;
    private final ByteBufAllocator byteBufAllocator;
    private final URI publicAddress;
    private final ImmutableList<String> indexFiles;
    private final ImmutableMap<String, String> other;
    private final SSLContext sslContext;
    private final int maxContentLength;
    private final boolean timeResponses;
    private final boolean compressResponses;

    public DefaultLaunchConfig(FileSystemBinding baseDir, int port, InetAddress address, boolean reloadable, int threads, ByteBufAllocator byteBufAllocator, URI publicAddress, ImmutableList<String> indexFiles, ImmutableMap<String, String> other, SSLContext sslContext, int maxContentLength, boolean timeResponses, boolean compressResponses, HandlerFactory handlerFactory) {
        this.baseDir = baseDir;
        this.port = port;
        this.address = address;
        this.reloadable = reloadable;
        this.threads = threads;
        this.timeResponses = timeResponses;
        this.compressResponses = compressResponses;
        this.byteBufAllocator = byteBufAllocator;
        this.publicAddress = publicAddress;
        this.indexFiles = indexFiles;
        this.other = other;
        this.handlerFactory = handlerFactory;
        this.sslContext = sslContext;
        this.maxContentLength = maxContentLength;
        this.execController = new DefaultExecController(this.threads);
    }

    @Override
    public FileSystemBinding getBaseDir() {
        if (this.baseDir == null) {
            throw new NoBaseDirException("No base dir has been set");
        }
        return this.baseDir;
    }

    @Override
    public HandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean isReloadable() {
        return this.reloadable;
    }

    @Override
    public int getThreads() {
        return this.threads;
    }

    @Override
    public ExecController getExecController() {
        return this.execController;
    }

    @Override
    public ByteBufAllocator getBufferAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public URI getPublicAddress() {
        return this.publicAddress;
    }

    @Override
    public List<String> getIndexFiles() {
        return this.indexFiles;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public String getOther(String key, String defaultValue) {
        String value = (String)this.other.get((Object)key);
        return value == null ? defaultValue : value;
    }

    @Override
    public Map<String, String> getOtherPrefixedWith(String prefix) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int prefixLength = prefix.length();
        for (Map.Entry property : this.other.entrySet()) {
            String key = (String)property.getKey();
            if (!key.startsWith(prefix) || key.length() <= prefixLength) continue;
            result.put(key.substring(prefixLength), (String)property.getValue());
        }
        return result;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public boolean isTimeResponses() {
        return this.timeResponses;
    }

    @Override
    public boolean isCompressResponses() {
        return this.compressResponses;
    }

    @Override
    public boolean isHasBaseDir() {
        return this.baseDir != null;
    }
}

