/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.RegistrySpec;
import ratpack.registry.internal.DefaultRegistryBuilder;
import ratpack.registry.internal.HierarchicalRegistry;

public abstract class Registries {
    private Registries() {
    }

    public static <O> RegistryBuilder add(Class<? super O> type, O object) {
        return Registries.registry().add(type, object);
    }

    public static RegistryBuilder add(Object object) {
        return Registries.registry().add(object);
    }

    public static <O> RegistryBuilder add(Class<O> type, Factory<? extends O> factory) {
        return Registries.registry().add(type, factory);
    }

    public static Registry join(Registry parent, Registry child) {
        return new HierarchicalRegistry(parent, child);
    }

    public static <T> Registry just(Class<T> publicType, Factory<? extends T> factory) {
        return Registries.registry().add(publicType, factory).build();
    }

    public static Registry just(Object object) {
        return Registries.registry().add(object).build();
    }

    public static <T> Registry just(Class<? super T> publicType, T implementation) {
        return Registries.registry().add(publicType, implementation).build();
    }

    public static RegistryBuilder registry() {
        return new DefaultRegistryBuilder();
    }

    public static Registry registry(Action<? super RegistrySpec> action) throws Exception {
        RegistryBuilder builder = Registries.registry();
        action.execute(builder);
        return builder.build();
    }
}

