/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class Types {
    public static ParameterizedType findParameterizeImplType(Type type, Class<?> searchType) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            if (rawType.equals(searchType)) {
                return parameterizedType;
            }
            return Types.findParameterizeImplType(rawType.getGenericSuperclass(), searchType);
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (type.equals(Object.class)) {
                throw new IllegalStateException(type + " does not extend " + searchType);
            }
            return Types.findParameterizeImplType(classType.getGenericSuperclass(), searchType);
        }
        throw new IllegalStateException("Unhandled type: " + type);
    }

    public static <T> Class<T> findImplParameterTypeAtIndex(Class<?> type, Class<?> searchType, int typeIndex) {
        ParameterizedType parameterizedType = Types.findParameterizeImplType(type.getGenericSuperclass(), searchType);
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (typeIndex >= actualTypeArguments.length) {
            throw new IllegalArgumentException("Cannot get type at index " + typeIndex + " of " + searchType + " impl of " + type + " as it only has " + actualTypeArguments.length + " types");
        }
        Type tType = actualTypeArguments[typeIndex];
        if (tType instanceof Class) {
            Class castType = (Class)tType;
            return castType;
        }
        if (tType instanceof ParameterizedType) {
            Class castType = (Class)((ParameterizedType)tType).getRawType();
            return castType;
        }
        throw new IllegalStateException("Type parameter " + typeIndex + " of " + type + " of impl " + searchType + " is not concrete");
    }
}

