/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

public class Result<T> {
    private final Throwable failure;
    private final T value;

    public static <T> Result<T> success(T value) {
        return new Result<T>(value);
    }

    public static <T> Result<T> failure(Throwable failure) {
        return new Result<T>(failure);
    }

    private Result(Throwable failure) {
        this.failure = failure;
        this.value = null;
    }

    private Result(T value) {
        this.value = value;
        this.failure = null;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isSuccess() {
        return this.failure == null;
    }

    public boolean isFailure() {
        return this.failure != null;
    }

    public T getValueOrThrow() throws Throwable {
        if (this.isFailure()) {
            throw this.failure;
        }
        return this.value;
    }
}

