/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.base.Joiner;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;

public class DefaultByMethodHandler
implements ratpack.handling.ByMethodHandler {
    private final Map<String, Runnable> runnables = new LinkedHashMap<String, Runnable>(2);

    @Override
    public ratpack.handling.ByMethodHandler get(Runnable runnable) {
        return this.named("GET", runnable);
    }

    @Override
    public ratpack.handling.ByMethodHandler post(Runnable runnable) {
        return this.named("POST", runnable);
    }

    @Override
    public ratpack.handling.ByMethodHandler put(Runnable runnable) {
        return this.named("PUT", runnable);
    }

    @Override
    public ratpack.handling.ByMethodHandler patch(Runnable runnable) {
        return this.named("PATCH", runnable);
    }

    @Override
    public ratpack.handling.ByMethodHandler delete(Runnable runnable) {
        return this.named("DELETE", runnable);
    }

    @Override
    public ratpack.handling.ByMethodHandler named(String methodName, Runnable runnable) {
        this.runnables.put(methodName.toUpperCase(), runnable);
        return this;
    }

    @Override
    public void handle(Context context) {
        if (context.getRequest().getMethod().isOptions()) {
            String methods = Joiner.on((String)",").join(this.runnables.keySet());
            context.getResponse().getHeaders().add("Allow", methods);
            context.getResponse().status(200).send();
        } else {
            Handler[] handlers = new Handler[this.runnables.size() + 1];
            int i = 0;
            for (Map.Entry<String, Runnable> entry : this.runnables.entrySet()) {
                handlers[i++] = new ByMethodHandler(entry.getKey(), entry.getValue());
            }
            handlers[i] = Handlers.clientError(HttpResponseStatus.METHOD_NOT_ALLOWED.code());
            context.insert(handlers);
        }
    }

    private static class ByMethodHandler
    implements Handler {
        private final Runnable runnable;
        private final String method;

        private ByMethodHandler(String method, Runnable runnable) {
            this.method = method;
            this.runnable = runnable;
        }

        @Override
        public void handle(Context context) {
            if (context.getRequest().getMethod().name(this.method)) {
                this.runnable.run();
            } else {
                context.next();
            }
        }
    }
}

