/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch;

import com.google.common.collect.Iterables;
import com.sun.nio.zipfs.ZipFileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;
import ratpack.launch.LaunchConfigBuilder;
import ratpack.launch.LaunchException;
import ratpack.ssl.SSLContexts;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.TypeCoercingProperties;

public abstract class LaunchConfigs {
    public static final String SYSPROP_PREFIX_PROPERTY = "ratpack.syspropPrefix";
    public static final String SYSPROP_PREFIX_DEFAULT = "ratpack.";
    public static final String CONFIG_RESOURCE_PROPERTY = "configResource";
    public static final String CONFIG_RESOURCE_DEFAULT = "ratpack.properties";

    private LaunchConfigs() {
    }

    public static LaunchConfig createFromGlobalProperties(ClassLoader classLoader, Properties globalProperties, Properties defaultProperties) {
        String propertyPrefix = globalProperties.getProperty(SYSPROP_PREFIX_PROPERTY, SYSPROP_PREFIX_DEFAULT);
        return LaunchConfigs.createFromGlobalProperties(classLoader, propertyPrefix, globalProperties, defaultProperties);
    }

    public static LaunchConfig createFromGlobalProperties(ClassLoader classLoader, String propertyPrefix, Properties globalProperties, Properties defaultProperties) {
        Properties deprefixed = new Properties();
        LaunchConfigs.extractProperties(propertyPrefix, globalProperties, deprefixed);
        return LaunchConfigs.createFromProperties(classLoader, deprefixed, defaultProperties);
    }

    public static Properties getDefaultPrefixedProperties() {
        Properties deprefixed = new Properties();
        LaunchConfigs.extractProperties(SYSPROP_PREFIX_DEFAULT, System.getProperties(), deprefixed);
        return deprefixed;
    }

    private static void extractProperties(String propertyPrefix, Properties properties, Map<? super String, ? super String> destination) {
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(propertyPrefix)) continue;
            destination.put(propertyName.substring(propertyPrefix.length()), properties.getProperty(propertyName));
        }
    }

    public static LaunchConfig createFromProperties(ClassLoader classLoader, Properties overrideProperties, Properties defaultProperties) {
        Path baseDir;
        Path configPath;
        String configResourceValue = overrideProperties.getProperty(CONFIG_RESOURCE_PROPERTY, CONFIG_RESOURCE_DEFAULT);
        URL configResourceUrl = classLoader.getResource(configResourceValue);
        if (configResourceUrl == null) {
            configPath = Paths.get(configResourceValue, new String[0]);
            if (!configPath.isAbsolute()) {
                configPath = Paths.get(System.getProperty("user.dir"), configResourceValue);
            }
            baseDir = configPath.getParent();
        } else {
            configPath = LaunchConfigs.resourceToPath(configResourceUrl);
            baseDir = configPath.getParent();
            if (baseDir == null && configPath.getFileSystem().provider() instanceof ZipFileSystemProvider) {
                baseDir = (Path)Iterables.getFirst(configPath.getFileSystem().getRootDirectories(), null);
            }
            if (baseDir == null) {
                throw new LaunchException("Cannot determine base dir given config resource: " + configPath);
            }
        }
        return LaunchConfigs.createFromFile(classLoader, baseDir, configPath, overrideProperties, defaultProperties);
    }

    private static Path resourceToPath(URL resource) {
        FileSystem fs;
        URI uri = LaunchConfigs.toUri(resource);
        String scheme = uri.getScheme();
        if (scheme.equals("file")) {
            return Paths.get(uri);
        }
        if (!scheme.equals("jar")) {
            throw new LaunchException("Cannot deal with class path resource url: " + uri);
        }
        String s = uri.toString();
        int separator = s.indexOf("!/");
        String entryName = s.substring(separator + 2);
        URI fileURI = URI.create(s.substring(0, separator));
        try {
            fs = FileSystems.newFileSystem(fileURI, Collections.emptyMap());
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck(e);
        }
        return fs.getPath(entryName, new String[0]);
    }

    private static URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new LaunchException("Could not convert URL '" + url + "' to URI", e);
        }
    }

    public static LaunchConfig createFromFile(ClassLoader classLoader, Path baseDir, Path configFile, Properties overrideProperties, Properties defaultProperties) {
        Properties fileProperties = new Properties(defaultProperties);
        if (configFile != null && Files.exists(configFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);){
                fileProperties.load(inputStream);
            }
            catch (Exception e) {
                throw new LaunchException("Could not read config file '" + configFile + "'", e);
            }
        }
        fileProperties.putAll((Map<?, ?>)overrideProperties);
        return LaunchConfigs.createWithBaseDir(classLoader, baseDir, fileProperties);
    }

    public static LaunchConfig createWithBaseDir(ClassLoader classLoader, Path baseDir, Properties properties) {
        return LaunchConfigs.createWithBaseDir(classLoader, baseDir, properties, System.getenv());
    }

    public static LaunchConfig createWithBaseDir(ClassLoader classLoader, Path baseDir, Properties properties, Map<String, String> envVars) {
        TypeCoercingProperties props = new TypeCoercingProperties(properties, classLoader);
        try {
            HandlerFactory handlerFactory;
            Class<HandlerFactory> handlerFactoryClass = props.asClass("handlerFactory", HandlerFactory.class);
            if (handlerFactoryClass == null) {
                throw new LaunchException("No handler factory class specified (config property: handlerFactory)");
            }
            int defaultPort = 5050;
            if (envVars.containsKey("PORT")) {
                try {
                    String stringValue = envVars.get("PORT");
                    defaultPort = Integer.valueOf(stringValue);
                }
                catch (NumberFormatException e) {
                    throw new LaunchException("Environment var 'PORT' is not an integer", e);
                }
            }
            int port = props.asInt("port", defaultPort);
            InetAddress address = props.asInetAddress("address");
            URI publicAddress = props.asURI("publicAddress");
            boolean reloadable = props.asBoolean("reloadable", false);
            int threads = props.asInt("threads", LaunchConfig.DEFAULT_THREADS);
            List<String> indexFiles = props.asList("indexFiles");
            InputStream sslKeystore = props.asStream("ssl.keystore.file");
            String sslKeystorePassword = props.asString("ssl.keystore.password", "");
            int maxContentLength = props.asInt("maxContentLength", 0x100000);
            boolean timeResponses = props.asBoolean("timeResponses", false);
            boolean compressResponses = props.asBoolean("compressResponses", false);
            long compressionMinSize = props.asLong("compression.minSize", 1024L);
            List<String> compressionMimeTypeWhiteList = props.asList("compression.mimeType.whiteList");
            List<String> compressionMimeTypeBlackList = props.asList("compression.mimeType.blackList");
            HashMap<String, String> otherProperties = new HashMap<String, String>();
            LaunchConfigs.extractProperties("other.", properties, otherProperties);
            try {
                handlerFactory = handlerFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new LaunchException("Could not instantiate handler factory: " + handlerFactoryClass.getName(), e);
            }
            LaunchConfigBuilder launchConfigBuilder = LaunchConfigBuilder.baseDir(baseDir).port(port).address(address).publicAddress(publicAddress).reloadable(reloadable).threads(threads).maxContentLength(maxContentLength).timeResponses(timeResponses).compressResponses(compressResponses).compressionMinSize(compressionMinSize).compressionWhiteListMimeTypes(compressionMimeTypeWhiteList).compressionBlackListMimeTypes(compressionMimeTypeBlackList).indexFiles(indexFiles);
            if (sslKeystore != null) {
                try (InputStream stream = sslKeystore;){
                    launchConfigBuilder.ssl(SSLContexts.sslContext(stream, sslKeystorePassword));
                }
            }
            return launchConfigBuilder.other(otherProperties).build(handlerFactory);
        }
        catch (Exception e) {
            if (e instanceof LaunchException) {
                throw (LaunchException)e;
            }
            throw new LaunchException("Failed to create launch config with properties: " + properties.toString(), e);
        }
    }

    public final class Property {
        public static final String PORT = "port";
        public static final String ADDRESS = "address";
        public static final String RELOADABLE = "reloadable";
        public static final String HANDLER_FACTORY = "handlerFactory";
        public static final String THREADS = "threads";
        public static final String PUBLIC_ADDRESS = "publicAddress";
        public static final String INDEX_FILES = "indexFiles";
        public static final String SSL_KEYSTORE_FILE = "ssl.keystore.file";
        public static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
        public static final String MAX_CONTENT_LENGTH = "maxContentLength";
        public static final String TIME_RESPONSES = "timeResponses";
        public static final String COMPRESS_RESPONSES = "compressResponses";
        public static final String COMPRESSION_MIN_SIZE = "compression.minSize";
        public static final String COMPRESSION_MIME_TYPE_WHITE_LIST = "compression.mimeType.whiteList";
        public static final String COMPRESSION_MIME_TYPE_BLACK_LIST = "compression.mimeType.blackList";

        private Property() {
        }
    }
}

