/*
 * Decompiled with CFR 0.152.
 */
package ratpack.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.handling.Context;

public class DebugErrorHandler
implements ServerErrorHandler,
ClientErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugErrorHandler.class);

    @Override
    public void error(Context context, Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        String stackTrace = ((Object)writer).toString();
        LOGGER.error(stackTrace);
        context.getResponse().status(500).send(stackTrace);
    }

    @Override
    public void error(Context context, int statusCode) {
        context.getResponse().status(statusCode).send(String.format("Client error %s", statusCode));
    }
}

