/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.internal.DefaultExecControl;

public class DefaultExecController
implements ExecController {
    private static final ThreadLocal<ExecController> THREAD_BINDING = new ThreadLocal();
    private final ListeningScheduledExecutorService computeExecutor;
    private final ListeningExecutorService blockingExecutor;
    private final EventLoopGroup eventLoopGroup;
    private final ExecControl control;
    private final int numThreads;

    public DefaultExecController(int numThreads) {
        this.numThreads = numThreads;
        this.eventLoopGroup = new NioEventLoopGroup(numThreads, (ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-compute", 10)));
        this.computeExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)this.eventLoopGroup);
        this.blockingExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool((ThreadFactory)((Object)new ExecControllerBindingThreadFactory("ratpack-blocking", 5))));
        this.control = new DefaultExecControl(this);
    }

    public static Optional<ExecController> getThreadBoundController() {
        return Optional.fromNullable((Object)THREAD_BINDING.get());
    }

    @Override
    public void close() {
        this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.blockingExecutor.shutdown();
    }

    @Override
    public ListeningScheduledExecutorService getExecutor() {
        return this.computeExecutor;
    }

    @Override
    public ListeningExecutorService getBlockingExecutor() {
        return this.blockingExecutor;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public ExecControl getControl() {
        return this.control;
    }

    @Override
    public boolean isManagedThread() {
        Optional<ExecController> threadBoundController = DefaultExecController.getThreadBoundController();
        return threadBoundController.isPresent() && threadBoundController.get() == this;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    private class ExecControllerBindingThreadFactory
    extends DefaultThreadFactory {
        public ExecControllerBindingThreadFactory(String name, int priority) {
            super(name, priority);
        }

        public Thread newThread(final Runnable r) {
            return super.newThread(new Runnable(){

                @Override
                public void run() {
                    THREAD_BINDING.set(DefaultExecController.this);
                    r.run();
                }
            });
        }
    }
}

