/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.ExecutionException;
import ratpack.exec.internal.DefaultExecution;
import ratpack.func.Action;
import ratpack.handling.internal.InterceptedOperation;

public class ExecutionBacking {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionBacking.class);
    private final List<ExecInterceptor> interceptors = new LinkedList<ExecInterceptor>();
    private final List<AutoCloseable> closeables = new LinkedList<AutoCloseable>();
    private final Deque<Runnable> segments = new ConcurrentLinkedDeque<Runnable>();
    private final ExecController controller;
    private final Action<? super Throwable> onError;
    private final Action<? super Execution> onComplete;
    private final ThreadLocal<ExecutionBacking> threadBinding;
    private final AtomicBoolean active = new AtomicBoolean();
    private boolean streaming;
    private boolean waiting;
    private boolean done;
    private final Execution execution;

    public ExecutionBacking(ExecController controller, ThreadLocal<ExecutionBacking> threadBinding, Action<? super Execution> action, Action<? super Throwable> onError, Action<? super Execution> onComplete) {
        this.controller = controller;
        this.onError = onError;
        this.onComplete = onComplete;
        this.threadBinding = threadBinding;
        this.execution = new DefaultExecution(controller, this.closeables);
        this.segments.addLast(new UserCodeSegment(action));
        this.tryDrain();
    }

    public Execution getExecution() {
        return this.execution;
    }

    public ExecController getController() {
        return this.controller;
    }

    public List<ExecInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void join(Action<? super Execution> action) {
        this.segments.addFirst(new UserCodeSegment(action));
        this.waiting = false;
        this.tryDrain();
    }

    public void continueVia(final Runnable runnable) {
        this.segments.addLast(new Runnable(){

            @Override
            public void run() {
                ExecutionBacking.this.waiting = true;
                runnable.run();
            }
        });
    }

    public void streamExecution(Action<? super Execution> action) {
        this.segments.add(new UserCodeSegment(action));
        this.streaming = true;
        this.tryDrain();
    }

    public void completeStreamExecution(Action<? super Execution> action) {
        this.segments.addLast(new UserCodeSegment(action));
        this.streaming = false;
        this.tryDrain();
    }

    private void tryDrain() {
        this.assertNotDone();
        if (!this.waiting && !this.segments.isEmpty() && this.active.compareAndSet(false, true)) {
            this.drain();
        }
    }

    private void done() {
        this.done = true;
        try {
            this.onComplete.execute(this.getExecution());
        }
        catch (Exception e) {
            LOGGER.warn("exception raised during onComplete action", (Throwable)e);
        }
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOGGER.warn(String.format("exception raised by closeable %s", closeable), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain() {
        if (this.controller.isManagedThread()) {
            this.threadBinding.set(this);
            try {
                Runnable segment = this.segments.poll();
                while (segment != null) {
                    segment.run();
                    if (this.waiting) {
                        break;
                    }
                    segment = this.segments.poll();
                    if (segment != null || this.streaming) continue;
                    this.done();
                }
            }
            finally {
                this.threadBinding.remove();
                this.active.set(false);
            }
            if (this.waiting) {
                this.tryDrain();
            }
        } else {
            this.active.set(false);
            this.controller.getEventLoopGroup().submit(new Runnable(){

                @Override
                public void run() {
                    ExecutionBacking.this.tryDrain();
                }
            });
        }
    }

    private void assertNotDone() {
        if (this.done) {
            throw new ExecutionException("execution is complete");
        }
    }

    public void intercept(ExecInterceptor.ExecType execType, List<ExecInterceptor> interceptors, final Action<? super Execution> action) throws Exception {
        new InterceptedOperation(execType, interceptors){

            @Override
            protected void performOperation() throws Exception {
                action.execute(ExecutionBacking.this.getExecution());
            }
        }.run();
    }

    private class UserCodeSegment
    implements Runnable {
        private final Action<? super Execution> action;

        public UserCodeSegment(Action<? super Execution> action) {
            this.action = action;
        }

        @Override
        public void run() {
            try {
                ExecutionBacking.this.intercept(ExecInterceptor.ExecType.COMPUTE, ExecutionBacking.this.interceptors, this.action);
            }
            catch (Throwable e) {
                ExecutionBacking.this.segments.clear();
                ExecutionBacking.this.segments.addFirst(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExecutionBacking.this.onError.execute(e);
                        }
                        catch (Throwable e2) {
                            ExecutionBacking.this.segments.addFirst(new UserCodeSegment((Action<? super Execution>)new Action<Execution>(){

                                @Override
                                public void execute(Execution execution) throws Exception {
                                    throw e2;
                                }
                            }));
                        }
                    }
                });
            }
        }
    }
}

