/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import java.io.FileInputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.Callable;
import ratpack.exec.ExecControl;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ChunkedInputAdapter;
import ratpack.file.internal.FileHttpTransmitter;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.func.Action;
import ratpack.http.internal.HttpHeaderConstants;

public class DefaultFileHttpTransmitter
implements FileHttpTransmitter {
    private final HttpHeaders httpHeaders;
    private final boolean compress;
    private final long compressionMinSize;
    private final ImmutableSet<String> compressionMimeTypeWhiteList;
    private final ImmutableSet<String> compressionMimeTypeBlackList;
    private final Action<? super Action<? super ResponseTransmitter>> transmitterAction;

    public DefaultFileHttpTransmitter(HttpHeaders httpHeaders, MimeTypes mimeTypes, boolean compress, Long compressionMinSize, ImmutableSet<String> compressionMimeTypeWhiteList, ImmutableSet<String> compressionMimeTypeBlackList, Action<? super Action<? super ResponseTransmitter>> transmitterAction) {
        this.httpHeaders = httpHeaders;
        this.compress = compress;
        this.compressionMinSize = compressionMinSize;
        this.compressionMimeTypeWhiteList = compressionMimeTypeWhiteList;
        this.compressionMimeTypeBlackList = compressionMimeTypeBlackList != null ? compressionMimeTypeBlackList : DefaultFileHttpTransmitter.defaultExcludedMimeTypes(mimeTypes);
        this.transmitterAction = transmitterAction;
    }

    private static ImmutableSet<String> defaultExcludedMimeTypes(MimeTypes mimeTypes) {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.filter(mimeTypes.getKnownMimeTypes(), (Predicate)new Predicate<String>(){

            public boolean apply(String type) {
                return (type.startsWith("image/") || type.startsWith("audio/") || type.startsWith("video/")) && !type.endsWith("+xml");
            }
        }), (Iterable)ImmutableSet.of((Object)"application/compress", (Object)"application/zip", (Object)"application/gzip")));
    }

    @Override
    public void transmit(ExecControl execContext, final BasicFileAttributes basicFileAttributes, final Path file) {
        boolean compressThis;
        boolean bl = compressThis = this.compress && basicFileAttributes.size() > this.compressionMinSize && this.isContentTypeCompressible();
        if (this.compress && !compressThis) {
            this.httpHeaders.set(HttpHeaderConstants.CONTENT_ENCODING, (Object)"identity");
        }
        if (file.getFileSystem().equals(FileSystems.getDefault()) && !compressThis) {
            execContext.blocking(new Callable<FileChannel>(){

                @Override
                public FileChannel call() throws Exception {
                    return new FileInputStream(file.toFile()).getChannel();
                }
            }).then(new Action<FileChannel>(){

                @Override
                public void execute(FileChannel fileChannel) throws Exception {
                    DefaultFileRegion defaultFileRegion = new DefaultFileRegion(fileChannel, 0L, basicFileAttributes.size());
                    DefaultFileHttpTransmitter.this.transmit(basicFileAttributes, defaultFileRegion);
                }
            });
        } else {
            execContext.blocking(new Callable<ReadableByteChannel>(){

                @Override
                public ReadableByteChannel call() throws Exception {
                    return Files.newByteChannel(file, new OpenOption[0]);
                }
            }).then(new Action<ReadableByteChannel>(){

                @Override
                public void execute(ReadableByteChannel fileChannel) throws Exception {
                    DefaultFileHttpTransmitter.this.transmit(basicFileAttributes, new ChunkedInputAdapter((ChunkedInput<ByteBuf>)new ChunkedNioStream(fileChannel)));
                }
            });
        }
    }

    private void transmit(BasicFileAttributes basicFileAttributes, final Object message) throws Exception {
        this.httpHeaders.set("Content-Length", (Object)basicFileAttributes.size());
        this.transmitterAction.execute(new Action<ResponseTransmitter>(){

            @Override
            public void execute(ResponseTransmitter responseTransmitter) {
                responseTransmitter.transmit(message);
            }
        });
    }

    private boolean isContentTypeCompressible() {
        String contentType = this.httpHeaders.get(HttpHeaderConstants.CONTENT_TYPE);
        PrefixMatchPredicate contentTypeMatch = new PrefixMatchPredicate(contentType);
        return (this.compressionMimeTypeWhiteList == null || contentType != null && Iterables.any(this.compressionMimeTypeWhiteList, (Predicate)contentTypeMatch)) && (contentType == null || !Iterables.any(this.compressionMimeTypeBlackList, (Predicate)contentTypeMatch));
    }

    private static class PrefixMatchPredicate
    implements Predicate<String> {
        private final String value;

        PrefixMatchPredicate(String value) {
            this.value = value;
        }

        public boolean apply(String possiblePrefix) {
            return this.value.startsWith(possiblePrefix);
        }
    }
}

