/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import ratpack.file.FileSystemChecksumService;

public class FileSystemChecksumServicePopulater {
    private final FileSystemChecksumService checksumService;
    private final ExecutorService executorService;
    private final int workers;
    private final Path root;
    private final LinkedBlockingQueue<Task> queue = new LinkedBlockingQueue();
    private AtomicBoolean started = new AtomicBoolean();
    private final CountDownLatch latch;

    public FileSystemChecksumServicePopulater(Path root, FileSystemChecksumService checksumService, ExecutorService executorService, int workers) {
        this.root = root;
        this.checksumService = checksumService;
        this.executorService = executorService;
        this.workers = workers;
        this.latch = new CountDownLatch(this.workers);
    }

    public boolean start() {
        if (!this.started.compareAndSet(false, true)) {
            return false;
        }
        this.executorService.submit(new FileSystemWalk());
        for (int i = 0; i < this.workers; ++i) {
            this.executorService.submit(new Checksummer());
        }
        return true;
    }

    public void waitFor() throws InterruptedException {
        this.start();
        this.latch.await();
    }

    private class Checksummer
    implements Runnable {
        private Checksummer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Task entry = (Task)FileSystemChecksumServicePopulater.this.queue.take();
                while (entry.path != null) {
                    try {
                        FileSystemChecksumServicePopulater.this.checksumService.checksum(entry.path);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entry = (Task)FileSystemChecksumServicePopulater.this.queue.take();
                }
                FileSystemChecksumServicePopulater.this.queue.put(entry);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                FileSystemChecksumServicePopulater.this.latch.countDown();
            }
        }
    }

    private class FileSystemWalk
    implements Runnable {
        private FileSystemWalk() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Files.walkFileTree(FileSystemChecksumServicePopulater.this.root, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            FileSystemChecksumServicePopulater.this.queue.put(new Task(FileSystemChecksumServicePopulater.this.root.relativize(file).toString()));
                            return FileVisitResult.CONTINUE;
                        }
                        catch (InterruptedException e) {
                            return FileVisitResult.TERMINATE;
                        }
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ignore) {
            }
            finally {
                try {
                    FileSystemChecksumServicePopulater.this.queue.put(new Task(null));
                }
                catch (InterruptedException ignore) {}
            }
        }
    }

    private static class Task {
        private final String path;

        private Task(String path) {
            this.path = path;
        }
    }
}

