/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import ratpack.func.Action;
import ratpack.util.ExceptionUtils;

public abstract class Actions {
    private static final Action<Throwable> THROW_EXCEPTION = new Action<Throwable>(){

        @Override
        public void execute(Throwable throwable) throws Exception {
            throw ExceptionUtils.toException(throwable);
        }
    };
    private static final Action<Object> NOOP = new Action<Object>(){

        @Override
        public void execute(Object thing) throws Exception {
        }
    };

    private Actions() {
    }

    public static Action<Object> noop() {
        return NOOP;
    }

    public static <T> Action<? super T> noopIfNull(Action<T> action) {
        if (action == null) {
            return Actions.noop();
        }
        return action;
    }

    @SafeVarargs
    public static <T> Action<T> join(final Action<? super T> ... actions) {
        return new Action<T>(){

            @Override
            public void execute(T thing) throws Exception {
                for (Action action : actions) {
                    action.execute(thing);
                }
            }
        };
    }

    public static Action<Throwable> throwException() {
        return THROW_EXCEPTION;
    }

    public static <T> Action<Action<? super T>> actionAction(final T t) {
        return new Action<Action<? super T>>(){

            @Override
            public void execute(Action<? super T> action) throws Exception {
                action.execute(t);
            }
        };
    }
}

