/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.event.internal.EventRegistry;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.func.Action;
import ratpack.handling.ByContentSpec;
import ratpack.handling.ByMethodSpec;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Redirector;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.handling.internal.DefaultByContentSpec;
import ratpack.handling.internal.DefaultByMethodSpec;
import ratpack.handling.internal.InternalServerThrowableWrapper;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.internal.ContentNegotiationHandler;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.MultiMethodHandler;
import ratpack.launch.LaunchConfig;
import ratpack.parse.NoSuchParserException;
import ratpack.parse.Parse;
import ratpack.parse.Parser;
import ratpack.parse.ParserException;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.path.internal.DefaultPathTokens;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.render.NoSuchRendererException;
import ratpack.render.internal.RenderController;
import ratpack.server.BindAddress;
import ratpack.util.ExceptionUtils;

public class DefaultContext
implements Context {
    private static final TypeToken<Parser<?>> PARSER_TYPE_TOKEN = new TypeToken<Parser<?>>(){
        private static final long serialVersionUID = 0L;
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultContext.class);
    private final RequestConstants requestConstants;
    private final Registry registry;
    private final Handler[] nextHandlers;
    private final int nextIndex;
    private final Handler exhausted;

    public static void start(ExecControl execControl, final RequestConstants requestConstants, Registry registry, Handler[] nextHandlers, Handler exhausted, Action<? super Execution> onComplete) {
        final DefaultContext context = new DefaultContext(requestConstants, registry, nextHandlers, 0, exhausted);
        execControl.fork((Action<? super Execution>)new Action<Execution>(){

            @Override
            public void execute(Execution execution) throws Exception {
                context.next();
            }
        }, (Action<? super Throwable>)new Action<Throwable>(){

            @Override
            public void execute(Throwable throwable) throws Exception {
                requestConstants.context.error(throwable instanceof HandlerException ? throwable.getCause() : throwable);
            }
        }, onComplete);
    }

    public DefaultContext(RequestConstants requestConstants, Registry registry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        this.requestConstants = requestConstants;
        this.registry = registry;
        this.nextHandlers = nextHandlers;
        this.nextIndex = nextIndex;
        this.exhausted = exhausted;
        this.requestConstants.context = this;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public ExecController getController() {
        return this.requestConstants.applicationConstants.execControl.getController();
    }

    @Override
    public Execution getExecution() {
        return this.requestConstants.applicationConstants.execControl.getExecution();
    }

    @Override
    public <T> Promise<T> blocking(Callable<T> blockingOperation) {
        return this.requestConstants.applicationConstants.execControl.blocking(blockingOperation);
    }

    @Override
    public <T> Promise<T> promise(Action<? super Fulfiller<T>> action) {
        return this.requestConstants.applicationConstants.execControl.promise(action);
    }

    @Override
    public void fork(Action<? super Execution> action) {
        this.requestConstants.applicationConstants.execControl.fork(action);
    }

    @Override
    public void fork(Action<? super Execution> action, Action<? super Throwable> onError) {
        this.requestConstants.applicationConstants.execControl.fork(action, onError);
    }

    @Override
    public void fork(Action<? super Execution> action, Action<? super Throwable> onError, Action<? super Execution> onComplete) {
        this.requestConstants.applicationConstants.execControl.fork(action, onError, onComplete);
    }

    @Override
    public void addInterceptor(ExecInterceptor execInterceptor, Action<? super Execution> continuation) throws Exception {
        this.requestConstants.applicationConstants.execControl.addInterceptor(execInterceptor, continuation);
    }

    @Override
    public <T> void stream(Publisher<T> publisher, Subscriber<? super T> subscriber) {
        this.requestConstants.applicationConstants.execControl.stream(publisher, subscriber);
    }

    @Override
    public LaunchConfig getLaunchConfig() {
        return this.requestConstants.applicationConstants.launchConfig;
    }

    @Override
    public Request getRequest() {
        return this.requestConstants.request;
    }

    @Override
    public Response getResponse() {
        return this.requestConstants.response;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(Class<O> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public void next() {
        this.doNext(this, this.registry, this.nextIndex, this.nextHandlers, this.exhausted);
    }

    @Override
    public void next(Registry registry) {
        Registry joinedRegistry = Registries.join(this.registry, registry);
        this.doNext(this, joinedRegistry, this.nextIndex, this.nextHandlers, new RejoinHandler());
    }

    @Override
    public void insert(Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.doNext(this, this.registry, 0, handlers, new RejoinHandler());
    }

    @Override
    public void insert(Registry registry, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        Registry joinedRegistry = Registries.join(this.registry, registry);
        this.doNext(this, joinedRegistry, 0, handlers, new RejoinHandler());
    }

    @Override
    public PathTokens getPathTokens() {
        PathBinding pathBinding = this.maybeGet(PathBinding.class);
        if (pathBinding == null) {
            return new DefaultPathTokens((ImmutableMap<String, String>)ImmutableMap.of());
        }
        return pathBinding.getTokens();
    }

    @Override
    public PathTokens getAllPathTokens() {
        return this.get(PathBinding.class).getAllTokens();
    }

    @Override
    public Path file(String path) {
        return this.get(FileSystemBinding.class).file(path);
    }

    @Override
    public void render(Object object) throws NoSuchRendererException {
        try {
            this.requestConstants.applicationConstants.renderController.render(object, this);
        }
        catch (NoSuchRendererException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public <T, O> T parse(Parse<T, O> parse) throws ParserException, NoSuchParserException {
        Parser<?> parser;
        String requestContentType = this.requestConstants.request.getBody().getContentType().getType();
        if (requestContentType == null) {
            requestContentType = "text/plain";
        }
        if ((parser = this.registry.first(PARSER_TYPE_TOKEN, new ParserForParsePredicate(parse, requestContentType))) != null) {
            Parser<?> castParser = parser;
            try {
                return castParser.parse(this, this.getRequest().getBody(), parse);
            }
            catch (Exception e) {
                throw new ParserException(parser, (Throwable)e);
            }
        }
        throw new NoSuchParserException(parse.getType(), parse.getOpts(), requestContentType);
    }

    @Override
    public <T> T parse(Class<T> type) throws NoSuchParserException, ParserException {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T> T parse(TypeToken<T> type) throws NoSuchParserException, ParserException {
        return this.parse(Parse.of(type));
    }

    @Override
    public <T, O> T parse(Class<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public <T, O> T parse(TypeToken<T> type, O opts) {
        return this.parse(Parse.of(type, opts));
    }

    @Override
    public void onClose(Action<? super RequestOutcome> callback) {
        this.requestConstants.onCloseRegistry.register(callback);
    }

    @Override
    public DirectChannelAccess getDirectChannelAccess() {
        return this.requestConstants.directChannelAccess;
    }

    @Override
    public void redirect(String location) {
        this.redirect(HttpResponseStatus.FOUND.code(), location);
    }

    @Override
    public void redirect(int code, String location) {
        Redirector redirector = this.registry.get(Redirector.class);
        redirector.redirect(this, location, code);
    }

    @Override
    public void lastModified(Date date, Runnable runnable) {
        long time;
        long ifModifiedSinceSecs;
        Date ifModifiedSinceHeader = this.requestConstants.request.getHeaders().getDate("If-Modified-Since");
        long lastModifiedSecs = date.getTime() / 1000L;
        if (ifModifiedSinceHeader != null && lastModifiedSecs == (ifModifiedSinceSecs = (time = ifModifiedSinceHeader.getTime()) / 1000L)) {
            this.requestConstants.response.status(HttpResponseStatus.NOT_MODIFIED.code(), HttpResponseStatus.NOT_MODIFIED.reasonPhrase()).send();
            return;
        }
        this.requestConstants.response.getHeaders().setDate(HttpHeaderConstants.LAST_MODIFIED, date);
        runnable.run();
    }

    @Override
    public BindAddress getBindAddress() {
        return this.requestConstants.bindAddress;
    }

    @Override
    public void error(Throwable throwable) {
        Throwable unwrappedThrowable;
        ServerErrorHandler serverErrorHandler = this.get(ServerErrorHandler.class);
        Throwable unpacked = this.unpackThrowable(throwable);
        InternalServerThrowableWrapper handledThrowable = this.getRequest().maybeGet(InternalServerThrowableWrapper.class);
        Throwable throwable2 = unwrappedThrowable = handledThrowable == null ? null : handledThrowable.getThrowable();
        if (unwrappedThrowable != null) {
            this.handleErrorHandlerThrowable(serverErrorHandler, unpacked, unwrappedThrowable);
        } else {
            this.getRequest().register(InternalServerThrowableWrapper.class, new InternalServerThrowableWrapper(unpacked));
            try {
                serverErrorHandler.error(this, unpacked);
            }
            catch (Throwable errorHandlerThrowable) {
                this.handleErrorHandlerThrowable(serverErrorHandler, unpacked, errorHandlerThrowable);
            }
        }
    }

    private void handleErrorHandlerThrowable(ServerErrorHandler serverErrorHandler, Throwable unpacked, Throwable errorHandlerThrowable) {
        StringBuilder sb = new StringBuilder();
        String originalThrowableMessage = "Throwable thrown by error handler " + serverErrorHandler.toString() + " while handling throwable\nOriginal throwable: ";
        LOGGER.error(originalThrowableMessage, unpacked);
        sb.append(originalThrowableMessage).append("\n");
        for (StackTraceElement element : unpacked.getStackTrace()) {
            sb.append(element.toString()).append("\n");
        }
        sb.append("\n");
        String handlerThrowableMessage = "Error handler throwable: ";
        LOGGER.error(handlerThrowableMessage, errorHandlerThrowable);
        sb.append(handlerThrowableMessage).append("\n");
        for (StackTraceElement element : errorHandlerThrowable.getStackTrace()) {
            sb.append(element.toString()).append("\n");
        }
        Response response = this.requestConstants.response.status(500);
        if (this.getLaunchConfig().isDevelopment()) {
            response.send(sb.toString());
        } else {
            response.send();
        }
    }

    private Throwable unpackThrowable(Throwable throwable) {
        if (throwable instanceof UndeclaredThrowableException) {
            return ExceptionUtils.toException(throwable.getCause());
        }
        return throwable;
    }

    @Override
    public void clientError(int statusCode) {
        try {
            this.get(ClientErrorHandler.class).error(this, statusCode);
        }
        catch (Throwable e) {
            this.error(ExceptionUtils.toException(e));
        }
    }

    @Override
    public void byMethod(Action<? super ByMethodSpec> action) throws Exception {
        LinkedHashMap<String, Handler> handlers = new LinkedHashMap<String, Handler>(2);
        DefaultByMethodSpec spec = new DefaultByMethodSpec(handlers);
        action.execute(spec);
        new MultiMethodHandler(handlers).handle(this);
    }

    @Override
    public void byContent(Action<? super ByContentSpec> action) throws Exception {
        LinkedHashMap<String, Handler> handlers = new LinkedHashMap<String, Handler>(2);
        DefaultByContentSpec spec = new DefaultByContentSpec(handlers);
        action.execute(spec);
        new ContentNegotiationHandler(handlers).handle(this);
    }

    protected void doNext(Context parentContext, Registry registry, int nextIndex, Handler[] nextHandlers, Handler exhausted) {
        Handler handler;
        Context context;
        if (nextIndex >= nextHandlers.length) {
            context = parentContext;
            handler = exhausted;
        } else {
            handler = nextHandlers[nextIndex];
            context = this.createContext(registry, nextHandlers, nextIndex + 1, exhausted);
        }
        try {
            this.requestConstants.handler = handler;
            handler.handle(context);
        }
        catch (Throwable e) {
            if (e instanceof HandlerException) {
                throw (HandlerException)e;
            }
            throw new HandlerException(e);
        }
    }

    @Override
    public <O> O get(TypeToken<O> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    @Override
    public <O> O maybeGet(TypeToken<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <T> T first(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.first(type, predicate);
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        return this.registry.all(type, predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        return this.registry.each(type, predicate, action);
    }

    private DefaultContext createContext(Registry registry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        return new DefaultContext(this.requestConstants, registry, nextHandlers, nextIndex, exhausted);
    }

    private static class ParserForParsePredicate
    implements Predicate<Parser<?>> {
        private final Parse<?, ?> parse;
        private final String contentType;

        private ParserForParsePredicate(Parse<?, ?> parse, String contentType) {
            this.parse = parse;
            this.contentType = contentType;
        }

        public boolean apply(Parser<?> parser) {
            return this.contentType.equalsIgnoreCase(parser.getContentType()) && parser.getOptsType().isInstance(this.parse.getOpts());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParserForParsePredicate that = (ParserForParsePredicate)o;
            return this.contentType.equalsIgnoreCase(that.contentType) && this.parse.equals(that.parse);
        }

        public int hashCode() {
            int result = this.contentType.hashCode();
            result = 31 * result + this.parse.hashCode();
            return result;
        }
    }

    private class RejoinHandler
    implements Handler {
        private RejoinHandler() {
        }

        @Override
        public void handle(Context context) throws Exception {
            DefaultContext.this.doNext(DefaultContext.this, DefaultContext.this.registry, DefaultContext.this.nextIndex, DefaultContext.this.nextHandlers, DefaultContext.this.exhausted);
        }
    }

    private static class HandlerException
    extends Error {
        private static final long serialVersionUID = 0L;

        private HandlerException(Throwable cause) {
            super(cause);
        }
    }

    public static class RequestConstants {
        private final ApplicationConstants applicationConstants;
        private final BindAddress bindAddress;
        private final Request request;
        private final Response response;
        private final DirectChannelAccess directChannelAccess;
        private final EventRegistry<RequestOutcome> onCloseRegistry;
        public Context context;
        public Handler handler;

        public RequestConstants(ApplicationConstants applicationConstants, BindAddress bindAddress, Request request, Response response, DirectChannelAccess directChannelAccess, EventRegistry<RequestOutcome> onCloseRegistry) {
            this.applicationConstants = applicationConstants;
            this.bindAddress = bindAddress;
            this.request = request;
            this.response = response;
            this.directChannelAccess = directChannelAccess;
            this.onCloseRegistry = onCloseRegistry;
        }
    }

    public static class ApplicationConstants {
        private final RenderController renderController;
        private final LaunchConfig launchConfig;
        private final ExecControl execControl;

        public ApplicationConstants(LaunchConfig launchConfig, RenderController renderController) {
            this.renderController = renderController;
            this.launchConfig = launchConfig;
            this.execControl = launchConfig.getExecController().getControl();
        }
    }
}

