/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import org.reactivestreams.Publisher;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.http.ResponseChunks;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.Renderer;
import ratpack.render.RendererSupport;

public class HttpResponseChunksRenderer
extends RendererSupport<ResponseChunks> {
    public static final TypeToken<Renderer<ResponseChunks>> TYPE = new TypeToken<Renderer<ResponseChunks>>(){};

    @Override
    public void render(Context context, ResponseChunks chunks) throws Exception {
        Response response = context.getResponse();
        response.getHeaders().add(HttpHeaderConstants.TRANSFER_ENCODING, HttpHeaderConstants.CHUNKED);
        response.getHeaders().set(HttpHeaderConstants.CONTENT_TYPE, chunks.getContentType());
        Publisher<? extends ByteBuf> publisher = chunks.publisher(context.getLaunchConfig().getBufferAllocator());
        response.sendStream(context, publisher);
    }
}

