/*
 * Decompiled with CFR 0.152.
 */
package ratpack.launch.internal;

import com.google.common.collect.Iterables;
import com.sun.nio.zipfs.ZipFileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import ratpack.launch.HandlerFactory;
import ratpack.launch.LaunchConfig;
import ratpack.launch.LaunchConfigBuilder;
import ratpack.launch.LaunchException;
import ratpack.launch.internal.LaunchConfigData;
import ratpack.ssl.SSLContexts;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.PropertiesUtil;
import ratpack.util.internal.TypeCoercingProperties;

public class LaunchConfigsInternal {
    private LaunchConfigsInternal() {
    }

    public static LaunchConfigData createFromGlobalProperties(String workingDir, ClassLoader classLoader, Properties globalProperties, Properties defaultProperties) {
        String propertyPrefix = globalProperties.getProperty("ratpack.syspropPrefix", "ratpack.");
        return LaunchConfigsInternal.createFromGlobalProperties(workingDir, classLoader, propertyPrefix, globalProperties, defaultProperties);
    }

    public static LaunchConfigData createFromGlobalProperties(String workingDir, ClassLoader classLoader, String propertyPrefix, Properties globalProperties, Properties defaultProperties) {
        Properties deprefixed = new Properties();
        PropertiesUtil.extractProperties(propertyPrefix, globalProperties, deprefixed);
        return LaunchConfigsInternal.createFromProperties(workingDir, classLoader, deprefixed, defaultProperties);
    }

    public static LaunchConfigData createFromProperties(String workingDir, ClassLoader classLoader, Properties overrideProperties, Properties defaultProperties) {
        Path baseDir;
        Path configPath;
        String configResourceValue = overrideProperties.getProperty("configResource", "ratpack.properties");
        URL configResourceUrl = classLoader.getResource(configResourceValue);
        if (configResourceUrl == null) {
            configPath = Paths.get(configResourceValue, new String[0]);
            if (!configPath.isAbsolute()) {
                configPath = Paths.get(workingDir, configResourceValue);
            }
            baseDir = configPath.getParent();
        } else {
            configPath = LaunchConfigsInternal.resourceToPath(configResourceUrl);
            baseDir = configPath.getParent();
            if (baseDir == null && configPath.getFileSystem().provider() instanceof ZipFileSystemProvider) {
                baseDir = (Path)Iterables.getFirst(configPath.getFileSystem().getRootDirectories(), null);
            }
            if (baseDir == null) {
                throw new LaunchException("Cannot determine base dir given config resource: " + configPath);
            }
        }
        return LaunchConfigsInternal.createFromFile(classLoader, baseDir, configPath, overrideProperties, defaultProperties);
    }

    public static LaunchConfigData createFromFile(ClassLoader classLoader, Path baseDir, Path configFile, Properties overrideProperties, Properties defaultProperties) {
        Properties fileProperties = new Properties(defaultProperties);
        if (configFile != null && Files.exists(configFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);){
                fileProperties.load(inputStream);
            }
            catch (Exception e) {
                throw new LaunchException("Could not read config file '" + configFile + "'", e);
            }
        }
        fileProperties.putAll((Map<?, ?>)overrideProperties);
        return LaunchConfigsInternal.createWithBaseDir(classLoader, baseDir, fileProperties);
    }

    public static LaunchConfigData createWithBaseDir(ClassLoader classLoader, Path baseDir, Properties properties) {
        return LaunchConfigsInternal.createWithBaseDir(classLoader, baseDir, properties, System.getenv());
    }

    public static LaunchConfigData createWithBaseDir(ClassLoader classLoader, Path baseDir, Properties properties, Map<String, String> envVars) {
        return new LaunchConfigData(classLoader, baseDir, properties, envVars);
    }

    public static LaunchConfig createLaunchConfig(LaunchConfigData data) {
        Properties properties = data.getProperties();
        Map<String, String> envVars = data.getEnvVars();
        TypeCoercingProperties props = new TypeCoercingProperties(properties, data.getClassLoader());
        try {
            HandlerFactory handlerFactory;
            Class<HandlerFactory> handlerFactoryClass = props.asClass("handlerFactory", HandlerFactory.class);
            if (handlerFactoryClass == null) {
                throw new LaunchException("No handler factory class specified (config property: handlerFactory)");
            }
            int defaultPort = 5050;
            if (envVars.containsKey("PORT")) {
                try {
                    String stringValue = envVars.get("PORT");
                    defaultPort = Integer.valueOf(stringValue);
                }
                catch (NumberFormatException e) {
                    throw new LaunchException("Environment var 'PORT' is not an integer", e);
                }
            }
            int port = props.asInt("port", defaultPort);
            InetAddress address = props.asInetAddress("address");
            URI publicAddress = props.asURI("publicAddress");
            boolean development = props.asBoolean("development", false);
            int threads = props.asInt("threads", LaunchConfig.DEFAULT_THREADS);
            List<String> indexFiles = props.asList("indexFiles");
            InputStream sslKeystore = props.asStream("ssl.keystore.file");
            String sslKeystorePassword = props.asString("ssl.keystore.password", "");
            int maxContentLength = props.asInt("maxContentLength", 0x100000);
            boolean timeResponses = props.asBoolean("timeResponses", false);
            boolean compressResponses = props.asBoolean("compressResponses", false);
            long compressionMinSize = props.asLong("compression.minSize", 1024L);
            List<String> compressionMimeTypeWhiteList = props.asList("compression.mimeType.whiteList");
            List<String> compressionMimeTypeBlackList = props.asList("compression.mimeType.blackList");
            HashMap<String, String> otherProperties = new HashMap<String, String>();
            PropertiesUtil.extractProperties("other.", properties, otherProperties);
            try {
                handlerFactory = handlerFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new LaunchException("Could not instantiate handler factory: " + handlerFactoryClass.getName(), e);
            }
            LaunchConfigBuilder launchConfigBuilder = LaunchConfigBuilder.baseDir(data.getBaseDir()).port(port).address(address).publicAddress(publicAddress).development(development).threads(threads).maxContentLength(maxContentLength).timeResponses(timeResponses).compressResponses(compressResponses).compressionMinSize(compressionMinSize).compressionWhiteListMimeTypes(compressionMimeTypeWhiteList).compressionBlackListMimeTypes(compressionMimeTypeBlackList).indexFiles(indexFiles);
            if (sslKeystore != null) {
                try (InputStream stream = sslKeystore;){
                    launchConfigBuilder.ssl(SSLContexts.sslContext(stream, sslKeystorePassword));
                }
            }
            return launchConfigBuilder.other(otherProperties).build(handlerFactory);
        }
        catch (Exception e) {
            if (e instanceof LaunchException) {
                throw (LaunchException)e;
            }
            throw new LaunchException("Failed to create launch config with properties: " + properties.toString(), e);
        }
    }

    private static Path resourceToPath(URL resource) {
        FileSystem fs;
        URI uri = LaunchConfigsInternal.toUri(resource);
        String scheme = uri.getScheme();
        if (scheme.equals("file")) {
            return Paths.get(uri);
        }
        if (!scheme.equals("jar")) {
            throw new LaunchException("Cannot deal with class path resource url: " + uri);
        }
        String s = uri.toString();
        int separator = s.indexOf("!/");
        String entryName = s.substring(separator + 2);
        URI fileURI = URI.create(s.substring(0, separator));
        try {
            fs = FileSystems.newFileSystem(fileURI, Collections.emptyMap());
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck(e);
        }
        return fs.getPath(entryName, new String[0]);
    }

    private static URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new LaunchException("Could not convert URL '" + url + "' to URI", e);
        }
    }
}

