/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import ratpack.util.ExceptionUtils;

public abstract class PredicateCacheability {
    private static final LoadingCache<Class<?>, Boolean> CACHEABLE_PREDICATE_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Boolean>(){

        public Boolean load(Class<?> key) throws Exception {
            Method equals = key.getDeclaredMethod("equals", Object.class);
            Class<?> declaringClass = equals.getDeclaringClass();
            return !declaringClass.equals(Object.class);
        }
    });

    private PredicateCacheability() {
    }

    public static boolean isCacheable(Predicate<?> predicate) {
        try {
            return (Boolean)CACHEABLE_PREDICATE_CACHE.get(predicate.getClass());
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    public static class CacheKey<T> {
        public final TypeToken<T> type;
        public final Predicate<? super T> predicate;

        public CacheKey(TypeToken<T> type, Predicate<? super T> predicate) {
            this.type = type;
            this.predicate = predicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return this.predicate.equals(that.predicate) && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.predicate.hashCode();
            return result;
        }
    }
}

