/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import ratpack.func.Factory;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.internal.CachingRegistry;
import ratpack.registry.internal.DefaultRegistryEntry;
import ratpack.registry.internal.LazyRegistryEntry;
import ratpack.registry.internal.MultiEntryRegistry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.registry.internal.SingleEntryRegistry;

public class DefaultRegistryBuilder
implements RegistryBuilder {
    private final ImmutableList.Builder<RegistryEntry<?>> builder = ImmutableList.builder();
    private int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <O> RegistryBuilder add(Class<? super O> type, O object) {
        return this.add(TypeToken.of(type), (Object)object);
    }

    @Override
    public <O> RegistryBuilder add(TypeToken<? super O> type, O object) {
        this.builder.add(new DefaultRegistryEntry<O>(type, object));
        ++this.size;
        return this;
    }

    @Override
    public RegistryBuilder add(Object object) {
        Class<?> type = object.getClass();
        ++this.size;
        return this.add((Class)type, object);
    }

    @Override
    public <O> RegistryBuilder add(Class<O> type, Factory<? extends O> factory) {
        return this.add(TypeToken.of(type), (Factory)factory);
    }

    @Override
    public <O> RegistryBuilder add(TypeToken<O> type, Factory<? extends O> factory) {
        this.builder.add(new LazyRegistryEntry<O>(type, factory));
        ++this.size;
        return this;
    }

    @Override
    public Registry build() {
        ImmutableList entries = this.builder.build();
        if (entries.size() == 1) {
            return new CachingRegistry(new SingleEntryRegistry((RegistryEntry)entries.get(0)));
        }
        return new CachingRegistry(new MultiEntryRegistry((List<? extends RegistryEntry<?>>)entries));
    }

    @Override
    public Registry build(Registry parent) {
        return Registries.join(parent, this.build());
    }
}

