/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.event.internal.DefaultEventController;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.handling.RequestOutcome;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.http.Request;
import ratpack.http.Status;
import ratpack.http.internal.CustomHttpResponse;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.util.internal.NumberUtil;

class DefaultResponseTransmitter
implements ResponseTransmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseTransmitter.class);
    private static final Runnable NOOP_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final AtomicBoolean transmitted;
    private final Channel channel;
    private final FullHttpRequest nettyRequest;
    private final Request ratpackRequest;
    private final HttpHeaders responseHeaders;
    private final Status responseStatus;
    private final DefaultEventController<RequestOutcome> requestOutcomeEventController;
    private final long startTime;
    private final boolean isKeepAlive;
    private long stopTime;
    private Runnable onWritabilityChanged = NOOP_RUNNABLE;

    public DefaultResponseTransmitter(AtomicBoolean transmitted, Channel channel, FullHttpRequest nettyRequest, Request ratpackRequest, HttpHeaders responseHeaders, Status responseStatus, DefaultEventController<RequestOutcome> requestOutcomeEventController, long startTime) {
        this.transmitted = transmitted;
        this.channel = channel;
        this.nettyRequest = nettyRequest.retain();
        this.ratpackRequest = ratpackRequest;
        this.responseHeaders = responseHeaders;
        this.responseStatus = responseStatus;
        this.requestOutcomeEventController = requestOutcomeEventController;
        this.startTime = startTime;
        this.isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)nettyRequest);
    }

    private ChannelFuture pre() {
        this.transmitted.set(true);
        this.stopTime = System.nanoTime();
        HttpResponseStatus nettyStatus = new HttpResponseStatus(this.responseStatus.getCode(), this.responseStatus.getMessage());
        CustomHttpResponse headersResponse = new CustomHttpResponse(nettyStatus, this.responseHeaders);
        this.nettyRequest.release();
        if (this.isKeepAlive) {
            headersResponse.headers().set(HttpHeaderConstants.CONNECTION, (Object)HttpHeaderConstants.KEEP_ALIVE);
        }
        if (this.startTime > 0L) {
            headersResponse.headers().set("X-Response-Time", (Object)NumberUtil.toMillisDiffString(this.startTime, this.stopTime));
        }
        if (this.channel.isOpen()) {
            return this.channel.writeAndFlush((Object)headersResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        return null;
    }

    @Override
    public void transmit(final Object body) {
        ChannelFuture channelFuture = this.pre();
        if (channelFuture == null) {
            return;
        }
        channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (DefaultResponseTransmitter.this.channel.isOpen()) {
                    DefaultResponseTransmitter.this.channel.write(body);
                    DefaultResponseTransmitter.this.post();
                }
            }
        });
    }

    @Override
    public Subscriber<Object> transmitter() {
        return new Subscriber<Object>(){
            private Subscription subscription;
            private final AtomicBoolean done = new AtomicBoolean();
            private final ChannelFutureListener cancelOnFailure = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!done.get() && !future.isSuccess()) {
                        this.cancel();
                    }
                }
            };

            private void cancel() {
                if (this.done.compareAndSet(false, true)) {
                    this.subscription.cancel();
                    DefaultResponseTransmitter.this.post();
                }
            }

            public void onSubscribe(Subscription s) {
                this.subscription = s;
                DefaultResponseTransmitter.this.onWritabilityChanged = new Runnable(){

                    @Override
                    public void run() {
                        if (DefaultResponseTransmitter.this.channel.isWritable() && !done.get()) {
                            subscription.request(1);
                        }
                    }
                };
                ChannelFuture channelFuture = DefaultResponseTransmitter.this.pre();
                if (channelFuture == null) {
                    s.cancel();
                    DefaultResponseTransmitter.this.notifyListeners(DefaultResponseTransmitter.this.channel.close());
                } else {
                    channelFuture.addListener((GenericFutureListener)this.cancelOnFailure);
                    if (DefaultResponseTransmitter.this.channel.isWritable()) {
                        this.subscription.request(1);
                    }
                }
            }

            public void onNext(Object o) {
                if (DefaultResponseTransmitter.this.channel.isOpen()) {
                    DefaultResponseTransmitter.this.channel.writeAndFlush(o).addListener((GenericFutureListener)this.cancelOnFailure);
                    if (DefaultResponseTransmitter.this.channel.isWritable()) {
                        this.subscription.request(1);
                    }
                }
            }

            public void onError(Throwable t) {
                LOGGER.debug("Exception thrown transmitting stream", t);
                this.cancel();
            }

            public void onComplete() {
                if (this.done.compareAndSet(false, true)) {
                    DefaultResponseTransmitter.this.post();
                }
            }
        };
    }

    private void post() {
        if (this.channel.isOpen()) {
            ChannelFuture lastContentFuture = this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!this.isKeepAlive) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.notifyListeners(lastContentFuture);
        } else {
            this.notifyListeners(this.channel.newSucceededFuture());
        }
    }

    private void notifyListeners(ChannelFuture future) {
        if (this.requestOutcomeEventController.isHasListeners()) {
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture ignore) throws Exception {
                    DefaultSentResponse sentResponse = new DefaultSentResponse(new NettyHeadersBackedHeaders(DefaultResponseTransmitter.this.responseHeaders), DefaultResponseTransmitter.this.responseStatus);
                    DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(DefaultResponseTransmitter.this.ratpackRequest, sentResponse, DefaultResponseTransmitter.this.stopTime);
                    DefaultResponseTransmitter.this.requestOutcomeEventController.fire(requestOutcome);
                }
            });
        }
    }

    public void writabilityChanged() {
        this.onWritabilityChanged.run();
    }
}

