/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultClientErrorHandler;
import ratpack.error.internal.DefaultServerErrorHandler;
import ratpack.event.internal.DefaultEventController;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.file.FileRenderer;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.DefaultFileHttpTransmitter;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.file.internal.ResponseTransmitter;
import ratpack.form.internal.FormParser;
import ratpack.func.Action;
import ratpack.func.Actions;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.Redirector;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.internal.DefaultDirectChannelAccess;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DefaultRedirector;
import ratpack.handling.internal.DescribingHandler;
import ratpack.handling.internal.DescribingHandlers;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClients;
import ratpack.http.internal.DefaultMutableStatus;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.HttpResponseChunksRenderer;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.render.CharSequenceRenderer;
import ratpack.render.internal.DefaultCharSequenceRenderer;
import ratpack.render.internal.DefaultRenderController;
import ratpack.server.PublicAddress;
import ratpack.server.Stopper;
import ratpack.server.internal.DefaultPublicAddress;
import ratpack.server.internal.DefaultResponseTransmitter;
import ratpack.server.internal.InetSocketAddressBackedBindAddress;
import ratpack.sse.internal.ServerSentEventsRenderer;
import ratpack.stream.internal.DefaultStreamTransmitter;

@ChannelHandler.Sharable
public class NettyHandlerAdapter
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final AttributeKey<DefaultResponseTransmitter> RESPONSE_TRANSMITTER_ATTRIBUTE_KEY = AttributeKey.valueOf((String)DefaultResponseTransmitter.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHandlerAdapter.class);
    private final Handler[] handlers;
    private final Handler return404;
    private final ConcurrentHashMap<Channel, Action<Object>> channelSubscriptions = new ConcurrentHashMap(0);
    private final DefaultContext.ApplicationConstants applicationConstants;
    private final ExecController execController;
    private final LaunchConfig launchConfig;
    private Registry registry;
    private final boolean addResponseTimeHeader;
    private final boolean compressResponses;
    private final long compressionMinSize;
    private final ImmutableSet<String> compressionMimeTypeWhiteList;
    private final ImmutableSet<String> compressionMimeTypeBlackList;

    public NettyHandlerAdapter(Stopper stopper, Handler handler, LaunchConfig launchConfig) {
        this.handlers = new Handler[]{handler};
        this.return404 = Handlers.notFound();
        this.launchConfig = launchConfig;
        this.registry = NettyHandlerAdapter.buildBaseRegistry(stopper, launchConfig);
        this.addResponseTimeHeader = launchConfig.isTimeResponses();
        this.compressResponses = launchConfig.isCompressResponses();
        this.compressionMinSize = launchConfig.getCompressionMinSize();
        this.compressionMimeTypeWhiteList = launchConfig.getCompressionMimeTypeWhiteList();
        this.compressionMimeTypeBlackList = launchConfig.getCompressionMimeTypeBlackList();
        this.applicationConstants = new DefaultContext.ApplicationConstants(launchConfig, new DefaultRenderController());
        this.execController = launchConfig.getExecController();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Action<Object> subscriber;
        if (!(msg instanceof FullHttpRequest) && (subscriber = this.channelSubscriptions.get(ctx.channel())) != null) {
            subscriber.execute(msg);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest nettyRequest) throws Exception {
        if (!nettyRequest.getDecoderResult().isSuccess()) {
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        long startTime = this.addResponseTimeHeader ? System.nanoTime() : 0L;
        final DefaultRequest request = new DefaultRequest(new NettyHeadersBackedHeaders(nettyRequest.headers()), nettyRequest.getMethod().name(), nettyRequest.getUri(), nettyRequest.content());
        final Channel channel = ctx.channel();
        DefaultMutableStatus responseStatus = new DefaultMutableStatus();
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(false);
        NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)nettyHeaders);
        MimeTypes mimeTypes = this.registry.get(MimeTypes.class);
        DefaultEventController<RequestOutcome> requestOutcomeEventController = new DefaultEventController<RequestOutcome>();
        final AtomicBoolean transmitted = new AtomicBoolean(false);
        DefaultResponseTransmitter responseTransmitter = new DefaultResponseTransmitter(transmitted, channel, nettyRequest, request, (HttpHeaders)nettyHeaders, responseStatus, requestOutcomeEventController, startTime);
        final Action<Action<DefaultResponseTransmitter>> responseTransmitterWrapper = Actions.actionAction(responseTransmitter);
        DefaultFileHttpTransmitter fileHttpTransmitter = new DefaultFileHttpTransmitter((HttpHeaders)nettyHeaders, mimeTypes, this.compressResponses, this.compressionMinSize, this.compressionMimeTypeWhiteList, this.compressionMimeTypeBlackList, responseTransmitterWrapper);
        DefaultStreamTransmitter streamTransmitter = new DefaultStreamTransmitter(responseTransmitter);
        final DefaultResponse response = new DefaultResponse(responseStatus, responseHeaders, fileHttpTransmitter, streamTransmitter, ctx.alloc(), (Action<? super ByteBuf>)new Action<ByteBuf>((HttpHeaders)nettyHeaders){
            final /* synthetic */ HttpHeaders val$nettyHeaders;
            {
                this.val$nettyHeaders = httpHeaders;
            }

            @Override
            public void execute(final ByteBuf byteBuf) throws Exception {
                responseTransmitterWrapper.execute(new Action<ResponseTransmitter>(){

                    @Override
                    public void execute(ResponseTransmitter responseTransmitter) throws Exception {
                        val$nettyHeaders.set("Content-Length", (Object)byteBuf.writerIndex());
                        responseTransmitter.transmit(new DefaultHttpContent(byteBuf));
                    }
                });
            }
        });
        ctx.attr(RESPONSE_TRANSMITTER_ATTRIBUTE_KEY).set((Object)responseTransmitter);
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        InetSocketAddressBackedBindAddress bindAddress = new InetSocketAddressBackedBindAddress(socketAddress);
        Action<Action<Object>> subscribeHandler = new Action<Action<Object>>(){

            @Override
            public void execute(Action<Object> thing) throws Exception {
                transmitted.set(true);
                NettyHandlerAdapter.this.channelSubscriptions.put(channel, thing);
                channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        NettyHandlerAdapter.this.channelSubscriptions.remove(channel);
                    }
                });
            }
        };
        DefaultDirectChannelAccess directChannelAccess = new DefaultDirectChannelAccess(channel, subscribeHandler);
        final DefaultContext.RequestConstants requestConstants = new DefaultContext.RequestConstants(this.applicationConstants, bindAddress, request, response, directChannelAccess, requestOutcomeEventController.getRegistry());
        DefaultContext.start(this.execController.getControl(), requestConstants, this.registry, this.handlers, this.return404, (Action<? super Execution>)new Action<Execution>(){

            @Override
            public void execute(Execution execution) throws Exception {
                if (!transmitted.get()) {
                    Handler lastHandler = requestConstants.handler;
                    StringBuilder description = new StringBuilder();
                    description.append("No response sent for ").append(request.getMethod().getName()).append(" request to ").append(request.getUri()).append(" (last handler: ");
                    if (lastHandler instanceof DescribingHandler) {
                        ((DescribingHandler)lastHandler).describeTo(description);
                    } else {
                        DescribingHandlers.describeTo(lastHandler, description);
                    }
                    description.append(")");
                    String message = description.toString();
                    LOGGER.warn(message);
                    response.status(500);
                    if (NettyHandlerAdapter.this.launchConfig.isDevelopment()) {
                        response.send(message);
                    } else {
                        response.send();
                    }
                }
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.isIgnorableException(cause)) {
            LOGGER.error("", cause);
            if (ctx.channel().isActive()) {
                NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ((DefaultResponseTransmitter)ctx.attr(RESPONSE_TRANSMITTER_ATTRIBUTE_KEY).get()).writabilityChanged();
    }

    private boolean isIgnorableException(Throwable throwable) {
        return throwable instanceof IOException && throwable.getMessage().equals("Connection reset by peer");
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set(HttpHeaderConstants.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static Registry buildBaseRegistry(Stopper stopper, LaunchConfig launchConfig) {
        RegistryBuilder registryBuilder = Registries.registry().add(Stopper.class, stopper).add(MimeTypes.class, new ActivationBackedMimeTypes()).add(PublicAddress.class, new DefaultPublicAddress(launchConfig.getPublicAddress(), launchConfig.getSSLContext() == null ? "http" : "https")).add(Redirector.class, new DefaultRedirector()).add(ClientErrorHandler.class, new DefaultClientErrorHandler()).add(ServerErrorHandler.class, new DefaultServerErrorHandler()).add(LaunchConfig.class, launchConfig).add(FileRenderer.class, new DefaultFileRenderer()).add(ServerSentEventsRenderer.TYPE, new ServerSentEventsRenderer(launchConfig.getBufferAllocator())).add(HttpResponseChunksRenderer.TYPE, new HttpResponseChunksRenderer()).add(CharSequenceRenderer.class, new DefaultCharSequenceRenderer()).add(FormParser.class, FormParser.multiPart()).add(FormParser.class, FormParser.urlEncoded()).add(HttpClient.class, HttpClients.httpClient(launchConfig));
        if (launchConfig.isHasBaseDir()) {
            registryBuilder.add(FileSystemBinding.class, launchConfig.getBaseDir());
        }
        return registryBuilder.build();
    }
}

