/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse.internal;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.CharsetUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import ratpack.func.Function;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.Renderer;
import ratpack.render.RendererSupport;
import ratpack.sse.ServerSentEvent;
import ratpack.sse.ServerSentEvents;
import ratpack.stream.Streams;
import ratpack.util.internal.ByteBufWriteThroughOutputStream;

public class ServerSentEventsRenderer
extends RendererSupport<ServerSentEvents> {
    public static final TypeToken<Renderer<ServerSentEvents>> TYPE = new TypeToken<Renderer<ServerSentEvents>>(){};
    private static final byte[] EVENT_TYPE_PREFIX = "event: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] EVENT_DATA_PREFIX = "data: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] EVENT_ID_PREFIX = "id: ".getBytes(CharsetUtil.UTF_8);
    private static final byte[] NEWLINE = "\n".getBytes(CharsetUtil.UTF_8);
    private static final CharSequence TEXT_EVENT_STREAM_CHARSET_UTF_8 = HttpHeaders.newEntity((String)"text/event-stream;charset=UTF-8");
    private final Encoder encoder;

    public ServerSentEventsRenderer(ByteBufAllocator bufferAllocator) {
        this.encoder = new Encoder(bufferAllocator);
    }

    @Override
    public void render(Context context, ServerSentEvents object) throws Exception {
        Response response = context.getResponse();
        response.getHeaders().add(HttpHeaderConstants.CONTENT_TYPE, TEXT_EVENT_STREAM_CHARSET_UTF_8);
        response.getHeaders().add(HttpHeaderConstants.CACHE_CONTROL, HttpHeaderConstants.NO_CACHE_FULL);
        response.getHeaders().add(HttpHeaderConstants.PRAGMA, HttpHeaderConstants.NO_CACHE);
        response.sendStream(context, Streams.map(object.getPublisher(), this.encoder));
    }

    public static class Encoder
    implements Function<ServerSentEvent, ByteBuf> {
        private final ByteBufAllocator bufferAllocator;

        public Encoder(ByteBufAllocator bufferAllocator) {
            this.bufferAllocator = bufferAllocator;
        }

        @Override
        public ByteBuf apply(ServerSentEvent serverSentEvent) throws Exception {
            String eventId;
            String eventData;
            ByteBuf buffer = this.bufferAllocator.buffer();
            ByteBufWriteThroughOutputStream outputStream = new ByteBufWriteThroughOutputStream(buffer);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, CharsetUtil.UTF_8);
            String eventType = serverSentEvent.getEventType();
            if (eventType != null) {
                ((OutputStream)outputStream).write(EVENT_TYPE_PREFIX);
                ((Writer)writer).append(eventType).flush();
                ((OutputStream)outputStream).write(NEWLINE);
            }
            if ((eventData = serverSentEvent.getEventData()) != null) {
                ((OutputStream)outputStream).write(EVENT_DATA_PREFIX);
                for (Character character : Lists.charactersOf((String)eventData)) {
                    if (character.charValue() == '\n') {
                        ((OutputStream)outputStream).write(NEWLINE);
                        ((OutputStream)outputStream).write(EVENT_DATA_PREFIX);
                        continue;
                    }
                    writer.append(character.charValue()).flush();
                }
                ((OutputStream)outputStream).write(NEWLINE);
            }
            if ((eventId = serverSentEvent.getEventId()) != null) {
                ((OutputStream)outputStream).write(EVENT_ID_PREFIX);
                ((Writer)writer).append(eventId).flush();
                ((OutputStream)outputStream).write(NEWLINE);
            }
            ((OutputStream)outputStream).write(NEWLINE);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            return buffer;
        }
    }
}

