/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.stream.StreamEvent;
import ratpack.stream.internal.BufferingPublisher;
import ratpack.stream.internal.GatedPublisher;
import ratpack.stream.internal.IterablePublisher;
import ratpack.stream.internal.PeriodicPublisher;
import ratpack.stream.internal.TransformingPublisher;
import ratpack.stream.internal.WiretapPublisher;

public class Streams {
    public static <T> Publisher<T> publish(Iterable<T> iterable) {
        return new IterablePublisher<T>(iterable);
    }

    public static <I, O> Publisher<O> map(Publisher<I> input, Function<? super I, ? extends O> function) {
        return new TransformingPublisher<O, I>(input, function);
    }

    public static <T> Publisher<T> throttle(Publisher<T> publisher) {
        return new BufferingPublisher<T>(publisher);
    }

    public static <T> Publisher<T> gate(Publisher<T> publisher, Action<? super Runnable> valveReceiver) {
        return new GatedPublisher<T>(publisher, valveReceiver);
    }

    public static <T> Publisher<T> periodically(ScheduledExecutorService executorService, long delay, TimeUnit timeUnit, Function<Integer, T> producer) {
        return Streams.throttle(new PeriodicPublisher<T>(executorService, producer, delay, timeUnit));
    }

    public static <T> Publisher<T> wiretap(Publisher<T> publisher, Action<? super StreamEvent<? super T>> listener) {
        return new WiretapPublisher<T>(publisher, listener);
    }
}

